/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.dialogs;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.internal.ui.breakpoints.CBreakpointPreferenceStore;
import org.eclipse.cdt.debug.internal.ui.dialogs.DialogMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.CBreakpointUIContributionFactory;
import org.eclipse.cdt.debug.ui.breakpoints.ICBreakpointsUIContribution;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AddEventBreakpointDialog
extends Dialog
implements ModifyListener,
SelectionListener {
    private Combo fEventTypeInput;
    private String fEventType;
    private String fEventArgument;
    private Composite fEventArgumentControl;
    private HashMap<String, String> fIdLabelMap = new LinkedHashMap<String, String>();
    private FieldEditorPreferencePage page;
    private CBreakpointUIContributionFactory factory;
    private String debugModelId;

    public AddEventBreakpointDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.factory = CBreakpointUIContributionFactory.getInstance();
        this.debugModelId = this.getDebugModelId();
        this.loadEventTypes();
    }

    protected String getDebugModelId() {
        return CDIDebugModel.getPluginIdentifier();
    }

    private void loadEventTypes() {
        ICBreakpointsUIContribution[] cons = this.factory.getBreakpointUIContributions(this.debugModelId, "org.eclipse.cdt.debug.core.cEventBreakpointMarker", null);
        int i = 0;
        while (i < cons.length) {
            ICBreakpointsUIContribution con = cons[i];
            if (con.getId().equals("org.eclipse.cdt.debug.core.eventbreakpoint_event_id")) {
                String[] possibleValues;
                String[] stringArray = possibleValues = con.getPossibleValues();
                int n = possibleValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    this.fIdLabelMap.put(value, con.getLabelForValue(value));
                    ++n2;
                }
            }
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        parent.setLayout((Layout)gridLayout);
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 100;
        composite.setLayoutData((Object)layoutData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createEventTypeControl(composite);
        this.createEventArgumentControl(composite);
        this.fEventTypeInput.setFocus();
        if (this.fEventTypeInput.getItemCount() > 0) {
            this.fEventTypeInput.select(0);
        }
        this.updateUI();
        return parent;
    }

    protected void createEventTypeControl(Composite parent) {
        this.fEventTypeInput = new Combo(parent, 2056);
        GridData gridData = new GridData(768);
        this.fEventTypeInput.setLayoutData((Object)gridData);
        for (String id : this.fIdLabelMap.keySet()) {
            this.addEventType(id, this.fIdLabelMap.get(id));
        }
        this.fEventTypeInput.addSelectionListener((SelectionListener)this);
        this.fEventTypeInput.select(0);
    }

    protected void addEventType(String id, String label) {
        int index = this.fEventTypeInput.getItemCount();
        this.fEventTypeInput.add(label, index);
        this.fEventTypeInput.setData(this.getIdDataKey(index), (Object)id);
    }

    private String getIdDataKey(int index) {
        return "index." + index;
    }

    protected void createEventArgumentControl(Composite parent) {
        this.fEventArgumentControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.fEventArgumentControl.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        this.fEventArgumentControl.setLayoutData((Object)gridData);
        this.updateEventType();
        if (this.fEventType != null) {
            this.createArgumentSpecificControl();
        }
    }

    private void createArgumentSpecificControl() {
        this.page = new ContributedFields(this.getDebugModelId(), this.fEventType);
        this.page.createControl(this.fEventArgumentControl);
        GridData gridData = new GridData(768);
        this.page.getControl().setLayoutData((Object)gridData);
    }

    private void updateArgumentsControl() {
        this.updateEventType();
        if (this.fEventTypeInput != null) {
            if (this.page != null) {
                Control control = this.page.getControl();
                control.dispose();
                this.page.dispose();
                this.page = null;
            }
            this.createArgumentSpecificControl();
            this.fEventArgumentControl.layout(true);
            this.getShell().pack();
        }
    }

    public boolean isActive() {
        return this.fIdLabelMap.size() > 0;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DialogMessages.getString("AddEventBreakpointDialog.2"));
    }

    protected void okPressed() {
        if (this.fEventTypeInput != null) {
            this.updateEventType();
        }
        if (this.page != null) {
            this.page.performOk();
            IPreferenceStore preferenceStore = this.page.getPreferenceStore();
            this.fEventArgument = preferenceStore != null ? preferenceStore.getString("org.eclipse.cdt.debug.core.eventbreakpoint_event_arg") : null;
        }
        super.okPressed();
    }

    private void updateEventType() {
        int index = this.fEventTypeInput.indexOf(this.fEventTypeInput.getText());
        if (index == -1) {
            this.fEventType = null;
            return;
        }
        Object data = this.fEventTypeInput.getData(this.getIdDataKey(index));
        this.fEventType = (String)data;
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() == this.fEventTypeInput) {
            this.updateArgumentsControl();
        }
        this.updateUI();
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.fEventTypeInput) {
            this.updateArgumentsControl();
        }
        this.updateUI();
    }

    private void updateUI() {
        Button b = this.getButton(0);
        if (b == null) {
            return;
        }
        b.setEnabled(this.okayEnabled());
    }

    private boolean okayEnabled() {
        String text = this.fEventTypeInput.getText();
        int index = this.fEventTypeInput.indexOf(text);
        return index != -1;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true).setEnabled(this.okayEnabled());
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public String getEventTypeId() {
        return this.fEventType;
    }

    public String getEventArgument() {
        return this.fEventArgument;
    }

    static class ContributedFields
    extends FieldEditorPreferencePage {
        private String modelId;
        private String eventType;

        ContributedFields(String modelId, String eventType) {
            this.modelId = modelId;
            this.eventType = eventType;
            this.noDefaultAndApplyButton();
            this.setPreferenceStore((IPreferenceStore)new CBreakpointPreferenceStore(){

                @Override
                public String getDefaultString(String name) {
                    return "";
                }
            });
        }

        protected void createFieldEditors() {
            Composite parent = this.getFieldEditorParent();
            try {
                ICBreakpointsUIContribution[] cons;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("org.eclipse.cdt.debug.core.eventbreakpoint_event_id", this.eventType);
                ICBreakpointsUIContribution[] iCBreakpointsUIContributionArray = cons = CBreakpointUIContributionFactory.getInstance().getBreakpointUIContributions(this.modelId, "org.eclipse.cdt.debug.core.cEventBreakpointMarker", map);
                int n = cons.length;
                int n2 = 0;
                while (n2 < n) {
                    ICBreakpointsUIContribution con = iCBreakpointsUIContributionArray[n2];
                    if (!con.getId().equals("org.eclipse.cdt.debug.core.eventbreakpoint_event_id") && !con.getId().equals("org.eclipse.cdt.debug.core.breakpointType")) {
                        FieldEditor fieldEditor = con.getFieldEditor(con.getId(), con.getLabel(), parent);
                        this.getPreferenceStore().setValue(con.getId(), "");
                        if (fieldEditor != null) {
                            this.addField(fieldEditor);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception ce) {
                CDebugUIPlugin.log(ce);
            }
        }
    }
}

