/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core.jsoncdb.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.jsoncdb.CompilationDatabaseInformation;
import org.eclipse.cdt.managedbuilder.core.jsoncdb.ICompilationDatabaseContributor;
import org.eclipse.cdt.managedbuilder.internal.core.jsoncdb.generator.CompilationDatabaseContributionManager;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;

public final class CompilationDatabaseGenerator {
    private static final String CDB_FILENAME = "compile_commands.json";
    private static final String ERROR_MESSAGE = "Can not set contents to compile_commands.json file";
    private IProject project;
    private IConfiguration configuration;
    private ICSourceEntry[] srcEntries;
    private Collection<IResource> fileList;

    public CompilationDatabaseGenerator(IProject proj, IConfiguration config) {
        this.project = proj;
        this.configuration = config;
        this.srcEntries = config.getSourceEntries();
    }

    public void generate() {
        IPath buildDirectory = ManagedBuildManager.getBuildFullPath(this.configuration, this.configuration.getBuilder());
        IPath compilationDatabasePath = buildDirectory.append("/compile_commands.json");
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (!workspace.getRoot().exists(buildDirectory)) {
                this.createDirectory(workspace.getRoot().getFolder(buildDirectory).getProjectRelativePath().toString());
            }
            IFile compileCommandsFile = this.createFile(compilationDatabasePath);
            this.addToCompilationdatabase(this.project, compileCommandsFile, this.configuration);
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).log(Status.error((String)"Unable to initialize the creation of compile_commands.json file", (Throwable)e));
        }
    }

    private IFile createFile(IPath compilationDatabasePath) throws CoreException {
        IFile newFile;
        block21: {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            newFile = workspace.getRoot().getFile(compilationDatabasePath);
            try {
                if (!newFile.exists()) {
                    Throwable throwable = null;
                    Object var5_9 = null;
                    try (ByteArrayInputStream inputStream = new ByteArrayInputStream("".getBytes());){
                        newFile.create((InputStream)inputStream, true, null);
                        break block21;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                Throwable throwable = null;
                Object var5_11 = null;
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream("".getBytes());){
                    newFile.setContents((InputStream)inputStream, true, false, null);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Status status = new Status(4, this.getClass(), ERROR_MESSAGE, (Throwable)e);
                Platform.getLog(this.getClass()).log((IStatus)status);
            }
        }
        return newFile;
    }

    private void addToCompilationdatabase(IProject project, IFile compileCommandsFile, @NonNull IConfiguration config) throws CoreException {
        ArrayList<CompilationDatabaseInformation> objList = new ArrayList<CompilationDatabaseInformation>();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        ResourceProxyVisitor resourceVisitor = new ResourceProxyVisitor(this, config);
        project.accept((IResourceProxyVisitor)resourceVisitor, 0);
        try {
            objList.addAll(this.populateObjList(project, config));
            objList.addAll(this.getRunnerForToolchain(config).getAdditionalFiles(config));
            CompilationDatabaseGenerator.save(gson.toJson(objList), compileCommandsFile);
        }
        catch (Exception e) {
            Status status = new Status(4, this.getClass(), ERROR_MESSAGE, (Throwable)e);
            Platform.getLog(this.getClass()).log((IStatus)status);
        }
    }

    private static void save(String buffer, IFile file) throws CoreException {
        byte[] bytes = buffer.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        boolean force = true;
        file.setContents((InputStream)stream, force, false, null);
    }

    private @NonNull ICompilationDatabaseContributor getRunnerForToolchain(@NonNull IConfiguration config) throws CoreException {
        return CompilationDatabaseContributionManager.getInstance().getCompilationDatabaseContributor(config);
    }

    /*
     * WARNING - void declaration
     */
    private List<CompilationDatabaseInformation> populateObjList(IProject project, IConfiguration config) throws CoreException, BuildException {
        ArrayList<CompilationDatabaseInformation> objList = new ArrayList<CompilationDatabaseInformation>();
        for (IResource resource : this.getFileList()) {
            Object tempPath;
            IPath[] addlInputPaths;
            IPath moduleRelativePath = resource.getParent().getProjectRelativePath();
            String relativePath = moduleRelativePath.toString();
            IFolder folder = project.getFolder(config.getName());
            IPath sourceLocation = this.getPathForResource(resource);
            String ext = sourceLocation.getFileExtension();
            IResourceInfo rcInfo = config.getResourceInfo(resource.getProjectRelativePath(), false);
            ITool tool = null;
            IResourceInfo iResourceInfo = rcInfo;
            if (iResourceInfo instanceof IFileInfo) {
                void fi;
                IFileInfo cfr_ignored_0 = (IFileInfo)iResourceInfo;
                IFileInfo cfr_ignored_1 = (IFileInfo)iResourceInfo;
                ITool[] tools = fi.getToolsToInvoke();
                if (tools != null && tools.length > 0) {
                    tool = tools[0];
                    ITool[] iToolArray = tools;
                    int n = tools.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITool tool2 = iToolArray[n2];
                        if (!tool2.getCustomBuildStep()) {
                            tool = tool2;
                            break;
                        }
                        ++n2;
                    }
                }
            } else {
                IResourceInfo iResourceInfo2 = rcInfo;
                if (iResourceInfo2 instanceof IFolderInfo) {
                    void foInfo;
                    ITool[] cfr_ignored_2 = (ITool[])iResourceInfo2;
                    IFolderInfo cfr_ignored_3 = (IFolderInfo)iResourceInfo2;
                    tool = foInfo.getToolFromInputExtension(ext);
                }
            }
            if (tool == null) continue;
            ArrayList<IPath> enumeratedPrimaryOutputs = new ArrayList<IPath>();
            this.calculateOutputsForSource(tool, relativePath, sourceLocation, enumeratedPrimaryOutputs);
            ArrayList<String> inputs = new ArrayList<String>();
            inputs.add(resource.getLocation().toString());
            IPath[] iPathArray = addlInputPaths = tool.getAdditionalDependencies();
            int n = addlInputPaths.length;
            int n3 = 0;
            while (n3 < n) {
                IPath addlInputPath = iPathArray[n3];
                IPath addlPath = addlInputPath;
                if (!addlPath.toString().startsWith("$(") && !addlPath.isAbsolute() && (tempPath = this.getPathForResource((IResource)project).append(addlPath)) != null) {
                    addlPath = ManagedBuildManager.calculateRelativePath(folder.getLocation(), (IPath)tempPath);
                }
                inputs.add(addlPath.toString());
                ++n3;
            }
            String[] inputStrings = inputs.toArray(new String[inputs.size()]);
            Object primaryOutputName = null;
            String resourceName = sourceLocation.removeFileExtension().lastSegment();
            if (!enumeratedPrimaryOutputs.isEmpty()) {
                if (enumeratedPrimaryOutputs.size() > 1) {
                    StringBuilder resultBuilder = new StringBuilder();
                    tempPath = enumeratedPrimaryOutputs.iterator();
                    while (tempPath.hasNext()) {
                        IPath outputPath = (IPath)tempPath.next();
                        resultBuilder.append(outputPath.toString()).append(" ");
                    }
                    primaryOutputName = resultBuilder.toString().trim();
                } else {
                    primaryOutputName = enumeratedPrimaryOutputs.get(0).toString();
                }
            } else {
                primaryOutputName = relativePath + "/" + resourceName + ".o";
            }
            IPath outputLocation = Path.fromOSString((String)primaryOutputName);
            if (!outputLocation.isAbsolute()) {
                outputLocation = this.getPathForResource((IResource)project).append(folder.getName()).append((String)primaryOutputName);
            }
            String outflag = tool.getOutputFlag();
            String outputPrefix = tool.getOutputPrefix();
            String[] flags = tool.getToolCommandFlags(sourceLocation, folder.getFullPath());
            IManagedCommandLineInfo cmdLInfo = this.generateToolCommandLineInfo(tool, flags, outflag, outputPrefix, String.valueOf(outputLocation), inputStrings, sourceLocation, outputLocation);
            IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
            String resolvedOptionFileContents = provider.resolveValueToMakefileFormat(cmdLInfo.getCommandLine(), "", " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
            objList.add(new CompilationDatabaseInformation(project.getLocation().toString(), resolvedOptionFileContents, resource.getLocation().toString()));
        }
        return objList;
    }

    private IManagedCommandLineInfo generateToolCommandLineInfo(ITool tool, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, IPath inputLocation, IPath outputLocation) {
        String cmd = tool.getToolCommand();
        try {
            String resolvedCommand = null;
            resolvedCommand = inputLocation != null && inputLocation.toString().indexOf(" ") != -1 || outputLocation != null && outputLocation.toString().indexOf(" ") != -1 ? ManagedBuildManager.getBuildMacroProvider().resolveValue(cmd, "", " ", 1, new FileContextData(inputLocation, outputLocation, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(cmd, "", " ", 1, new FileContextData(inputLocation, outputLocation, null, tool));
            resolvedCommand = resolvedCommand.trim();
            if (resolvedCommand.length() > 0) {
                cmd = resolvedCommand;
            }
        }
        catch (BuildMacroException e) {
            Platform.getLog(this.getClass()).log(Status.error((String)ERROR_MESSAGE, (Throwable)((Object)e)));
        }
        IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
        return gen.generateCommandLineInfo(tool, cmd, flags, outputFlag, outputPrefix, outputName, inputResources, tool.getCommandLinePattern());
    }

    private void calculateOutputsForSource(ITool tool, String relativePath, IPath sourceLocation, ArrayList<IPath> enumeratedPrimaryOutputs) {
        IOutputType[] outTypes = tool.getOutputTypes();
        if (outTypes != null && outTypes.length > 0) {
            IOutputType type = tool.getPrimaryOutputType();
            boolean primaryOutput = type == tool.getPrimaryOutputType();
            String[] extensions = type.getOutputExtensions(tool);
            if (primaryOutput) {
                String[] stringArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    String prefix = type.getOutputPrefix();
                    String fileName = sourceLocation.removeFileExtension().lastSegment();
                    IPath outPath = Path.fromOSString((String)(relativePath + "/" + prefix + fileName));
                    outPath = outPath.addFileExtension(extension);
                    enumeratedPrimaryOutputs.add(0, outPath);
                    ++n2;
                }
            }
        }
    }

    private IPath getPathForResource(IResource resource) {
        return new Path(resource.getLocationURI().getPath());
    }

    private boolean isSource(IPath path) {
        return !CDataUtil.isExcluded((IPath)path, (ICSourceEntry[])this.srcEntries);
    }

    private void appendFileList(IResource resource) {
        this.getFileList().add(resource);
    }

    private Collection<IResource> getFileList() {
        if (this.fileList == null) {
            this.fileList = new LinkedHashSet<IResource>();
        }
        return this.fileList;
    }

    private boolean isGeneratedResource(IResource resource) {
        String[] configNames;
        IPath path = resource.getProjectRelativePath();
        String[] stringArray = configNames = ManagedBuildManager.getBuildInfo((IResource)this.project).getConfigurationNames();
        int n = configNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Path root = new Path(name);
            if (root.isPrefixOf(path)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IPath createDirectory(String dirName) throws CoreException {
        IFolder folder = this.project.getFolder(dirName);
        if (!folder.exists()) {
            IFolder parent;
            IPath parentPath = new Path(dirName).removeLastSegments(1);
            if (!parentPath.isEmpty() && !(parent = this.project.getFolder(parentPath)).exists()) {
                this.createDirectory(parentPath.toString());
            }
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 374) {
                    folder.refreshLocal(0, null);
                }
                throw e;
            }
            if (!folder.isDerived()) {
                folder.setDerived(true, null);
            }
        }
        return folder.getFullPath();
    }

    private class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private final CompilationDatabaseGenerator generator;
        private final IConfiguration config;

        public ResourceProxyVisitor(CompilationDatabaseGenerator generator, IConfiguration cfg) {
            this.generator = generator;
            this.config = cfg;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (this.generator == null) {
                return false;
            }
            IResource resource = proxy.requestResource();
            boolean isSource = CompilationDatabaseGenerator.this.isSource(resource.getProjectRelativePath());
            if (proxy.getType() == 1) {
                IResourceInfo rcInfo = this.config.getResourceInfo(resource.getProjectRelativePath(), false);
                if (isSource) {
                    if (rcInfo instanceof IFolderInfo) {
                        String ext = resource.getFileExtension();
                        boolean buildFile = ((IFolderInfo)rcInfo).buildsFileType(ext);
                        if (buildFile && !this.generator.isGeneratedResource(resource)) {
                            this.generator.appendFileList(resource);
                        }
                    } else {
                        this.generator.appendFileList(resource);
                    }
                }
            } else if (proxy.getType() == 2) {
                return isSource && !this.generator.isGeneratedResource(resource);
            }
            return true;
        }
    }
}

