/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list.primitive;

import java.util.Comparator;
import java.util.Random;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.block.comparator.primitive.DoubleComparator;
import org.eclipse.collections.api.block.function.primitive.DoubleIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.DoubleList;
import org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import org.eclipse.collections.api.tuple.primitive.DoubleDoublePair;
import org.eclipse.collections.api.tuple.primitive.DoubleObjectPair;

public interface MutableDoubleList
extends MutableDoubleCollection,
DoubleList {
    public void addAtIndex(int var1, double var2);

    public boolean addAllAtIndex(int var1, double ... var2);

    public boolean addAllAtIndex(int var1, DoubleIterable var2);

    public double removeAtIndex(int var1);

    public double set(int var1, double var2);

    default public void swap(int index1, int index2) {
        double value = this.get(index1);
        this.set(index1, this.get(index2));
        this.set(index2, value);
    }

    @Override
    public MutableDoubleList select(DoublePredicate var1);

    @Override
    public MutableDoubleList reject(DoublePredicate var1);

    @Override
    public MutableDoubleList with(double var1);

    @Override
    public MutableDoubleList without(double var1);

    @Override
    public MutableDoubleList withAll(DoubleIterable var1);

    @Override
    public MutableDoubleList withoutAll(DoubleIterable var1);

    @Override
    default public MutableDoubleList tap(DoubleProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    default public MutableDoubleList selectWithIndex(DoubleIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.select(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    @Override
    default public MutableDoubleList rejectWithIndex(DoubleIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.reject(each -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each, n);
        });
    }

    public <V> MutableList<V> collect(DoubleToObjectFunction<? extends V> var1);

    default public <V> MutableList<V> collectWithIndex(DoubleIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((double each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each, n);
        });
    }

    public MutableDoubleList reverseThis();

    @Override
    public MutableDoubleList toReversed();

    @Override
    public MutableDoubleList distinct();

    public MutableDoubleList sortThis();

    default public MutableDoubleList sortThis(DoubleComparator comparator) {
        throw new UnsupportedOperationException("sortThis(DoubleComparator comparator) is not supported on " + this.getClass());
    }

    default public <T> MutableDoubleList sortThisBy(DoubleToObjectFunction<T> function) {
        return this.sortThisBy(function, Comparator.naturalOrder());
    }

    default public <T> MutableDoubleList sortThisBy(DoubleToObjectFunction<T> function, Comparator<? super T> comparator) {
        return this.sortThis((i1, i2) -> comparator.compare((Object)function.valueOf(i1), (Object)function.valueOf(i2)));
    }

    default public MutableDoubleList shuffleThis() {
        return this.shuffleThis(new Random());
    }

    default public MutableDoubleList shuffleThis(Random rnd) {
        for (int j = this.size() - 1; j > 0; --j) {
            int k = rnd.nextInt(j + 1);
            double selected = this.get(j);
            this.set(j, this.get(k));
            this.set(k, selected);
        }
        return this;
    }

    @Override
    public MutableDoubleList asUnmodifiable();

    @Override
    public MutableDoubleList asSynchronized();

    @Override
    public ImmutableDoubleList toImmutable();

    @Override
    public MutableDoubleList subList(int var1, int var2);

    default public MutableList<DoubleDoublePair> zipDouble(DoubleIterable iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    default public <T> MutableList<DoubleObjectPair<T>> zip(Iterable<T> list) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    @Override
    default public MutableDoubleList newEmpty() {
        throw new UnsupportedOperationException("Implement in concrete classes.");
    }
}

