/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import org.eclipse.collections.api.stack.primitive.MutableIntStack;
import org.eclipse.collections.impl.factory.primitive.IntStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.stack.mutable.primitive.SynchronizedIntStack;

public class UnmodifiableIntStack
implements MutableIntStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntStack stack;

    public UnmodifiableIntStack(MutableIntStack stack) {
        this.stack = Objects.requireNonNull(stack);
    }

    @Override
    public void push(int item) {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    @Override
    public int pop() {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public IntList pop(int count) {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    @Override
    public int peek() {
        return this.stack.peek();
    }

    @Override
    public IntList peek(int count) {
        return this.stack.peek(count);
    }

    @Override
    public int peekAt(int index) {
        return this.stack.peekAt(index);
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.stack.notEmpty();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean contains(int value) {
        return this.stack.contains(value);
    }

    @Override
    public boolean containsAll(int ... source) {
        return this.stack.containsAll(source);
    }

    @Override
    public boolean containsAll(IntIterable source) {
        return this.stack.containsAll(source);
    }

    @Override
    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(this.stack.intIterator());
    }

    @Override
    public void each(IntProcedure procedure) {
        this.stack.forEach(procedure);
    }

    @Override
    public int count(IntPredicate predicate) {
        return this.stack.count(predicate);
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return this.stack.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return this.stack.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return this.stack.noneSatisfy(predicate);
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    @Override
    public MutableIntStack select(IntPredicate predicate) {
        return this.stack.select(predicate);
    }

    @Override
    public MutableIntStack reject(IntPredicate predicate) {
        return this.stack.reject(predicate);
    }

    @Override
    public <V> MutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        return this.stack.collect((IntToObjectFunction)function);
    }

    @Override
    public long sum() {
        return this.stack.sum();
    }

    @Override
    public int max() {
        return this.stack.max();
    }

    @Override
    public int min() {
        return this.stack.min();
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return this.stack.minIfEmpty(defaultValue);
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return this.stack.maxIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.stack.average();
    }

    @Override
    public double median() {
        return this.stack.median();
    }

    @Override
    public MutableIntList toSortedList() {
        return this.stack.toSortedList();
    }

    @Override
    public int[] toSortedArray() {
        return this.stack.toSortedArray();
    }

    @Override
    public int[] toArray() {
        return this.stack.toArray();
    }

    @Override
    public int[] toArray(int[] target) {
        return this.stack.toArray(target);
    }

    @Override
    public String toString() {
        return this.stack.toString();
    }

    @Override
    public String makeString() {
        return this.stack.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.stack.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.stack.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.stack.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.stack.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.stack.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableIntList toList() {
        return this.stack.toList();
    }

    @Override
    public MutableIntSet toSet() {
        return this.stack.toSet();
    }

    @Override
    public MutableIntBag toBag() {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack) {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode() {
        return this.stack.hashCode();
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public MutableIntStack asUnmodifiable() {
        return this;
    }

    @Override
    public MutableIntStack asSynchronized() {
        return new SynchronizedIntStack(this);
    }

    @Override
    public ImmutableIntStack toImmutable() {
        return IntStacks.immutable.withAllReversed(this);
    }

    @Override
    public MutableIntStack newEmpty() {
        return this.stack.newEmpty();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return this.stack.injectInto(injectedValue, function);
    }

    @Override
    public RichIterable<IntIterable> chunk(int size) {
        return this.stack.chunk(size);
    }

    @Override
    public int getFirst() {
        return this.stack.getFirst();
    }

    @Override
    public int indexOf(int value) {
        return this.stack.indexOf(value);
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function) {
        return this.stack.injectIntoWithIndex(injectedValue, function);
    }

    @Override
    public void forEachWithIndex(IntIntProcedure procedure) {
        this.stack.forEachWithIndex(procedure);
    }

    @Override
    public <V> MutableStack<V> collectWithIndex(IntIntToObjectFunction<? extends V> function) {
        return this.stack.collectWithIndex((IntIntToObjectFunction)function);
    }

    @Override
    public <V, R extends Collection<V>> R collectWithIndex(IntIntToObjectFunction<? extends V> function, R target) {
        return this.stack.collectWithIndex(function, target);
    }
}

