/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import com.ibm.icu.text.Collator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.ProfileImageSafeRunnable;
import org.eclipse.datatools.connectivity.ui.Messages;

public class ProfileImageDescriptor
implements Comparable {
    public static final String PROFILE_IMAGE_TAG = "profileImage";
    private static final String EXTENSION_POINT_NAME = "connectionProfileImage";
    public static final String ATTR_ID = "profileID";
    public static final String ATTR_ICON = "icon";
    private URL mIconURL;
    private static final ProfileImageDescriptor[] EMPTY = new ProfileImageDescriptor[0];
    private static Map fgProfileImageDescriptors;
    private IConfigurationElement fElement;

    protected ProfileImageDescriptor(IConfigurationElement element) {
        this.fElement = element;
        Assert.isNotNull((Object)this.getId(), (String)Messages.ProfileImageDescriptor_target_profile_id_not_null_msg);
        Assert.isNotNull((Object)this.getIcon(), (String)Messages.ProfileImageDescriptor_target_profile_image_not_null);
    }

    public static ProfileImageDescriptor[] getProfileImageDescriptors() {
        if (fgProfileImageDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_POINT_NAME);
            ProfileImageDescriptor.createProfileImageDescriptors(elements);
        }
        if (fgProfileImageDescriptors.size() > 0) {
            return fgProfileImageDescriptors.values().toArray(new ProfileImageDescriptor[fgProfileImageDescriptors.size()]);
        }
        return EMPTY;
    }

    public static ProfileImageDescriptor[] getProfileImageDescriptorsForProfileID(String profileID) {
        ProfileImageDescriptor[] descriptors = ProfileImageDescriptor.getProfileImageDescriptors();
        if (descriptors != null && descriptors.length > 0) {
            ArrayList<ProfileImageDescriptor> result = new ArrayList<ProfileImageDescriptor>();
            int i = 0;
            while (i < descriptors.length) {
                if (descriptors[i].getId().equals(profileID)) {
                    result.add(descriptors[i]);
                }
                ++i;
            }
            return result.toArray(new ProfileImageDescriptor[result.size()]);
        }
        return EMPTY;
    }

    public String getId() {
        return this.fElement.getAttribute(ATTR_ID);
    }

    public String getIcon() {
        return this.fElement.getAttribute(ATTR_ICON);
    }

    public IConfigurationElement getElement() {
        return this.fElement;
    }

    public int compareTo(Object o) {
        if (o instanceof ProfileImageDescriptor) {
            return Collator.getInstance().compare(this.getId(), ((ProfileImageDescriptor)o).getId());
        }
        return Integer.MIN_VALUE;
    }

    private static void createProfileImageDescriptors(IConfigurationElement[] elements) {
        fgProfileImageDescriptors = new HashMap();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (PROFILE_IMAGE_TAG.equals(element.getName())) {
                ProfileImageDescriptor[] desc = new ProfileImageDescriptor[1];
                SafeRunner.run((ISafeRunnable)new ProfileImageSafeRunnable(desc, element));
                if (desc != null) {
                    fgProfileImageDescriptors.put(desc[0].getId(), desc[0]);
                }
            }
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProfileImageDescriptor) {
            ProfileImageDescriptor compare = (ProfileImageDescriptor)obj;
            return this.getId().equals(compare.getId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return super.hashCode();
    }

    private void processIconAttr() {
        String iconAttr;
        String string = iconAttr = this.fElement == null ? null : this.fElement.getAttribute(ATTR_ICON);
        if (iconAttr != null && iconAttr.trim().length() > 0) {
            if (iconAttr.startsWith("platform:/")) {
                try {
                    this.mIconURL = new URL(iconAttr);
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                this.mIconURL = Platform.getBundle((String)this.fElement.getContributor().getName()).getEntry(iconAttr);
            }
        }
    }

    public URL getIconURL() {
        if (this.mIconURL == null) {
            this.processIconAttr();
        }
        return this.mIconURL;
    }
}

