/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.loaders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.enablement.ingres.internal.loaders.LoaderHelper;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.IngresDBEvent;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.IngressqlmodelFactory;
import org.eclipse.datatools.modelbase.sql.schema.Schema;

public class IngresDBEventLoader
extends JDBCBaseLoader {
    private static final String DB_EVENT_QUERY = "SELECT DISTINCT event_name, event_owner FROM iievents WHERE event_owner = ?";
    private static final String DB_EVENT_NAME = "event_name";

    public IngresDBEventLoader() {
        this(null);
    }

    public IngresDBEventLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public IngresDBEventLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
    }

    public void loadDbEvents(List containmentList, List existingDBEvents) throws SQLException {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            stmt = this.getCatalogObject().getConnection().prepareStatement(DB_EVENT_QUERY);
            rs = this.createResultSet(stmt);
            String dbEventName = null;
            while (rs.next()) {
                dbEventName = rs.getString(DB_EVENT_NAME).trim();
                IngresDBEvent dbEvent = (IngresDBEvent)this.getAndRemoveSQLObject(existingDBEvents, dbEventName);
                if (dbEvent == null) {
                    dbEvent = this.processRow(rs);
                    if (dbEvent == null) continue;
                    containmentList.add(dbEvent);
                    continue;
                }
                containmentList.add(dbEvent);
                if (!(dbEvent instanceof ICatalogObject)) continue;
                ((ICatalogObject)dbEvent).refresh();
            }
        }
        catch (Throwable throwable) {
            LoaderHelper.close(rs);
            LoaderHelper.close(stmt);
            throw throwable;
        }
        LoaderHelper.close(rs);
        LoaderHelper.close(stmt);
    }

    public void clearDbEvents(List existingDbEvents) {
        existingDbEvents.clear();
    }

    protected ResultSet createResultSet(PreparedStatement stmt) throws SQLException {
        try {
            String schema = ((Schema)this.getCatalogObject()).getName();
            stmt.setString(1, schema);
            return stmt.executeQuery();
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException("Error while retrieving catalog information (db event)");
            error.initCause(e);
            throw error;
        }
    }

    protected IngresDBEvent processRow(ResultSet rs) throws SQLException {
        IngresDBEvent dbEvent = this.createDBEvent();
        this.initialize(dbEvent, rs);
        return dbEvent;
    }

    protected void initialize(IngresDBEvent dbEvent, ResultSet rs) throws SQLException {
        String triggerName = rs.getString(DB_EVENT_NAME).trim();
        dbEvent.setName(triggerName);
    }

    protected IngresDBEvent createDBEvent() {
        return IngressqlmodelFactory.eINSTANCE.createIngresDBEvent();
    }
}

