/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui;

import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptExceptionBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptLineBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptSpawnpoint;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptType;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.debug.ui.DLTKDebugUILanguageManager;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.Messages;
import org.eclipse.dltk.debug.ui.ScriptDebugImages;
import org.eclipse.dltk.debug.ui.breakpoints.BreakpointUtils;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.util.HandleFactory;
import org.eclipse.dltk.internal.debug.ui.DetailFormatter;
import org.eclipse.dltk.internal.debug.ui.ExternalFileEditorInput;
import org.eclipse.dltk.internal.debug.ui.ScriptDetailFormattersManager;
import org.eclipse.dltk.internal.debug.ui.ScriptEvaluationContextManager;
import org.eclipse.dltk.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.internal.ui.editor.ISourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.launching.debug.DebuggingEngineManager;
import org.eclipse.dltk.launching.debug.IDebuggingEngine;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public abstract class ScriptDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    private HashMap<String, Object> fAttributes = new HashMap();
    protected static final String SUSPENDED_LABEL = "suspended";
    protected static final String RUNNING_LABEL = "running";

    public static IDebuggingEngine getDebuggingEngine(IDebugElement element) {
        String id = element.getLaunch().getAttribute("debugging_engine_id");
        if (id == null) {
            return null;
        }
        return DebuggingEngineManager.getInstance().getDebuggingEngine(id);
    }

    public static IProject getProject(IDebugElement element) throws CoreException {
        ILaunchConfiguration configuration = element.getLaunch().getLaunchConfiguration();
        if (configuration == null) {
            return null;
        }
        String projectName = configuration.getAttribute("project", null);
        if (projectName == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static IScriptThread getEvaluationThread(IScriptDebugTarget target) {
        IScriptThread thread = null;
        IScriptStackFrame frame = ScriptEvaluationContextManager.getEvaluationContext(null);
        if (frame != null) {
            thread = (IScriptThread)frame.getThread();
        }
        if (!(thread == null || thread.getDebugTarget().equals(target) && thread.isSuspended())) {
            thread = null;
        }
        if (thread == null) {
            try {
                IThread[] threads = target.getThreads();
                int i = 0;
                while (i < threads.length) {
                    if (threads[i].isSuspended()) {
                        thread = (IScriptThread)threads[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (DebugException e) {
                DLTKDebugUIPlugin.log(e);
            }
        }
        return thread;
    }

    protected String getDebugTargetText(IScriptDebugTarget target) {
        IDebuggingEngine engine = ScriptDebugModelPresentation.getDebuggingEngine((IDebugElement)target);
        if (engine != null) {
            return NLS.bind((String)Messages.ScriptDebugModelPresentation_debugTargetText, (Object)engine.getName(), (Object)target.getSessionId());
        }
        return target.toString();
    }

    protected String getThreadText(IScriptThread thread) {
        try {
            return NLS.bind((String)Messages.ScriptDebugModelPresentation_threadText, (Object)thread.getName(), (Object)(thread.isSuspended() ? SUSPENDED_LABEL : RUNNING_LABEL));
        }
        catch (DebugException e) {
            DLTKDebugUIPlugin.log(e);
            return thread.toString();
        }
    }

    protected static IPath getStackFrameRelativePath(IScriptStackFrame stackFrame) throws CoreException {
        Path realPath;
        URI uri = stackFrame.getSourceURI();
        IProject project = ScriptDebugModelPresentation.getProject((IDebugElement)stackFrame);
        if (project == null) {
            return Path.EMPTY;
        }
        Path projectPath = new Path(project.getLocationURI().getPath());
        if (projectPath.isPrefixOf((IPath)(realPath = new Path(uri.getPath())))) {
            Path path = Path.EMPTY;
            int index = projectPath.segmentCount();
            while (index < realPath.segmentCount()) {
                path = path.append(realPath.segment(index));
                ++index;
            }
            return path;
        }
        return realPath;
    }

    protected String getStackFrameText(IScriptStackFrame stackFrame) {
        try {
            ILaunch launch;
            ISourceLocator sourceLocator;
            String sourceLine = stackFrame.getSourceLine();
            URI sourceURI = stackFrame.getSourceURI();
            if ((sourceLine == null || sourceLine.length() == 0) && (sourceLocator = (launch = stackFrame.getLaunch()).getSourceLocator()) != null) {
                Object object = sourceLocator.getSourceElement((IStackFrame)stackFrame);
                if (object instanceof IFile) {
                    ISourceModuleDocumentProvider provider = DLTKUIPlugin.getDocumentProvider();
                    IDocument document = provider.getDocument((Object)new FileEditorInput((IFile)object));
                    if (document != null) {
                        try {
                            sourceLine = ScriptDebugModelPresentation.retrieveStackFrameLine(stackFrame, document);
                        }
                        catch (BadLocationException e) {
                            DLTKDebugUIPlugin.log(e);
                        }
                    }
                } else {
                    sourceLine = "unknown".equalsIgnoreCase(sourceURI.getScheme()) ? sourceURI.getFragment() : ScriptDebugModelPresentation.toString(sourceURI);
                }
            }
            if (sourceLine == null || sourceLine.length() == 0) {
                int level = stackFrame.getStack().size() - stackFrame.getLevel() - 1;
                sourceLine = NLS.bind((String)Messages.ScriptDebugModelPresentation_stackFrameText, (Object)level);
            }
            if (stackFrame.getLineNumber() > 0) {
                if ("file".equalsIgnoreCase(sourceURI.getScheme())) {
                    IPath path = ScriptDebugModelPresentation.getStackFrameRelativePath(stackFrame);
                    return NLS.bind((String)Messages.ScriptDebugModelPresentation_stackFrameText2, (Object[])new Object[]{sourceLine, path.toString(), stackFrame.getLineNumber()});
                }
                return NLS.bind((String)Messages.ScriptDebugModelPresentation_stackFrameText3, (Object)sourceLine, (Object)stackFrame.getLineNumber());
            }
            return sourceLine;
        }
        catch (CoreException e) {
            DLTKDebugUIPlugin.log(e);
            return stackFrame.toString();
        }
    }

    private static String toString(URI uri) {
        StringBuffer sb = new StringBuffer();
        if (uri.getScheme() != null) {
            sb.append(uri.getScheme());
            sb.append(':');
        }
        if (uri.isOpaque()) {
            sb.append(uri.getSchemeSpecificPart());
        } else {
            String host = uri.getHost();
            if (host != null) {
                boolean needBrackets;
                sb.append("//");
                if (uri.getUserInfo() != null) {
                    sb.append(uri.getUserInfo());
                    sb.append('@');
                }
                boolean bl = needBrackets = host.indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
                if (needBrackets) {
                    sb.append('[');
                }
                sb.append(host);
                if (needBrackets) {
                    sb.append(']');
                }
                if (uri.getPort() != -1) {
                    sb.append(':');
                    sb.append(uri.getPort());
                }
            } else if (uri.getAuthority() != null) {
                sb.append("//");
                sb.append(uri.getAuthority());
            }
            if (uri.getPath() != null) {
                sb.append(uri.getPath());
            }
            if (uri.getQuery() != null) {
                sb.append('?');
                sb.append(uri.getQuery());
            }
        }
        if (uri.getFragment() != null) {
            sb.append('#');
            sb.append(uri.getFragment());
        }
        return sb.toString();
    }

    private static String retrieveStackFrameLine(IScriptStackFrame frame, IDocument document) throws BadLocationException, DebugException {
        if (frame.getBeginLine() > 0 && frame.getEndLine() > 0) {
            IRegion region = document.getLineInformation(frame.getBeginLine() - 1);
            int start = region.getOffset() + frame.getBeginColumn();
            int len = frame.getBeginLine() == frame.getEndLine() ? frame.getEndColumn() - frame.getBeginColumn() + 1 : region.getLength() - frame.getBeginColumn();
            return document.get(start, len).trim();
        }
        IRegion region = document.getLineInformation(frame.getLineNumber() - 1);
        return document.get(region.getOffset(), region.getLength()).trim();
    }

    public String getVariableName(IVariable variable) throws DebugException {
        return variable.getName();
    }

    public String getVariableText(IScriptVariable variable) {
        try {
            Object name = this.getVariableName((IVariable)variable);
            IScriptValue value = (IScriptValue)variable.getValue();
            if (value != null) {
                String valueText;
                IScriptType type;
                if (this.isShowVariableTypeNames() && (type = value.getType()) != null) {
                    String typeName = this.getTypeNameText(type);
                    name = typeName + " " + (String)name;
                }
                if ((valueText = this.getValueText(value)) != null && valueText.length() > 0) {
                    return (String)name + " = " + valueText;
                }
            }
            return name;
        }
        catch (DebugException e) {
            DLTKDebugUIPlugin.log(e);
            return variable.toString();
        }
    }

    protected boolean isShowLabelDetails(IScriptValue value) {
        IScriptDebugTarget target = (IScriptDebugTarget)value.getDebugTarget();
        String natureId = target.getLanguageToolkit().getNatureId();
        IPreferenceStore store = DLTKDebugUILanguageManager.getLanguageToolkit(natureId).getPreferenceStore();
        String details = store.getString("org.eclipse.dltk.debug.ui.show_details");
        boolean showDetails = false;
        if ("INLINE_ALL".equals(details)) {
            showDetails = true;
        } else if ("INLINE_FORMATTERS".equals(details)) {
            DetailFormatter formatter = ScriptDetailFormattersManager.getDefault(natureId).getDetailFormatter(value);
            showDetails = formatter != null && formatter.isEnabled();
        }
        return showDetails;
    }

    protected String getValueText(IScriptValue value) {
        String text = null;
        if (this.isShowLabelDetails(value)) {
            text = this.getVariableDetail(value);
        } else {
            try {
                text = value.getValueString();
            }
            catch (DebugException e) {
                DebugPlugin.log((Throwable)e);
                text = value.toString();
            }
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVariableDetail(IScriptValue value) {
        String[] detail = new String[1];
        Object lock = new Object();
        this.computeDetail((IValue)value, (computedValue, result) -> {
            Object object2 = lock;
            synchronized (object2) {
                stringArray[0] = result;
                lock.notifyAll();
            }
        });
        Object object = lock;
        synchronized (object) {
            if (detail[0] == null) {
                try {
                    lock.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return detail[0];
    }

    public String getDetailPaneText(IScriptValue value) {
        return value.getDetailsString();
    }

    protected String renderUnknownValue(IScriptValue value) throws DebugException {
        return value.getValueString();
    }

    protected String getBreakpointText(IScriptBreakpoint breakpoint) {
        try {
            StringBuffer sb = new StringBuffer();
            String language = BreakpointUtils.getLanguageToolkit(breakpoint).getLanguageName();
            int hitCount = breakpoint.getHitCount();
            if (breakpoint instanceof IScriptWatchpoint) {
                IScriptWatchpoint w = (IScriptWatchpoint)breakpoint;
                String file = w.getResourceName();
                int lineNumber = w.getLineNumber();
                String fieldName = w.getFieldName();
                if (lineNumber >= 0 && file != null) {
                    sb.append(NLS.bind((String)Messages.ScriptDebugModelPresentation_breakpointText, (Object[])new Object[]{language, file, lineNumber, fieldName}));
                } else {
                    sb.append(NLS.bind((String)Messages.ScriptDebugModelPresentation_breakpointNoResourceText, (Object)language, (Object)fieldName));
                }
            } else if (breakpoint instanceof IScriptLineBreakpoint) {
                IScriptLineBreakpoint b = (IScriptLineBreakpoint)breakpoint;
                String file = b.getResourceName();
                int lineNumber = b.getLineNumber();
                sb.append(NLS.bind((String)Messages.ScriptDebugModelPresentation_breakpointText2, (Object[])new Object[]{language, file, lineNumber}));
            } else if (breakpoint instanceof IScriptExceptionBreakpoint) {
                IScriptExceptionBreakpoint b = (IScriptExceptionBreakpoint)breakpoint;
                Object typeName = b.getTypeName();
                if (b.isSuspendOnSubclasses()) {
                    typeName = (String)typeName + Messages.ScriptDebugModelPresentation_breakpointText3;
                }
                sb.append(NLS.bind((String)Messages.ScriptDebugModelPresentation_breakpointText4, (Object)language, (Object)typeName));
            }
            if (hitCount != -1) {
                sb.append(NLS.bind((String)Messages.ScriptDebugModelPresentation_breakpointText5, (Object)hitCount));
            }
            return sb.toString();
        }
        catch (CoreException e) {
            DLTKDebugUIPlugin.log(e);
            return breakpoint.toString();
        }
    }

    protected String getExpressionText(IExpression expression) {
        IErrorReportingExpression errorExpression;
        Object expressionText = expression.getExpressionText();
        if (expression instanceof IErrorReportingExpression && (errorExpression = (IErrorReportingExpression)expression).hasErrors()) {
            return expressionText;
        }
        IScriptValue value = (IScriptValue)expression.getValue();
        if (value != null) {
            IScriptType type;
            if (this.isShowVariableTypeNames() && (type = value.getType()) != null) {
                String typeName = this.getTypeNameText(type);
                expressionText = typeName + " " + (String)expressionText;
            }
            return NLS.bind((String)Messages.ScriptDebugModelPresentation_expressionText, (Object)expressionText, (Object)this.getValueText(value));
        }
        return expressionText;
    }

    public String getTypeNameText(IScriptType type) {
        return type.getName();
    }

    public final String getText(Object element) {
        if (element instanceof IScriptDebugTarget) {
            return this.getDebugTargetText((IScriptDebugTarget)element);
        }
        if (element instanceof IScriptBreakpoint) {
            return this.getBreakpointText((IScriptBreakpoint)element);
        }
        if (element instanceof IScriptThread) {
            return this.getThreadText((IScriptThread)element);
        }
        if (element instanceof IScriptStackFrame) {
            return this.getStackFrameText((IScriptStackFrame)element);
        }
        if (element instanceof IScriptVariable) {
            return this.getVariableText((IScriptVariable)element);
        }
        if (element instanceof IScriptValue) {
            return this.getValueText((IScriptValue)element);
        }
        if (element instanceof IExpression) {
            return this.getExpressionText((IExpression)element);
        }
        if (element instanceof IScriptType) {
            return this.getTypeNameText((IScriptType)element);
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        if (value instanceof IScriptValue) {
            IScriptDebugTarget target = (IScriptDebugTarget)value.getDebugTarget();
            IScriptThread thread = ScriptDebugModelPresentation.getEvaluationThread(target);
            if (thread == null) {
                listener.detailComputed(value, ((IScriptValue)value).getDetailsString());
            } else {
                String natureId = target.getLanguageToolkit().getNatureId();
                ScriptDetailFormattersManager.getDefault(natureId).computeValueDetail((IScriptValue)value, thread, listener);
            }
        } else {
            listener.detailComputed(value, value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String id, Object value) {
        if (value == null) {
            return;
        }
        HashMap<String, Object> hashMap = this.fAttributes;
        synchronized (hashMap) {
            this.fAttributes.put(id, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isShowVariableTypeNames() {
        HashMap<String, Object> hashMap = this.fAttributes;
        synchronized (hashMap) {
            Boolean show = (Boolean)this.fAttributes.get("org.eclipse.debug.ui.displayVariableTypeNames");
            show = show == null ? Boolean.FALSE : show;
            return show;
        }
    }

    protected Image getBreakpointImage(IScriptBreakpoint breakpoint) {
        if (breakpoint instanceof IScriptSpawnpoint) {
            try {
                return ScriptDebugImages.get(breakpoint.isEnabled() ? "IMG_OBJS_SPAWNPOINT" : "IMG_OBJS_SPAWNPOINT_DISABLED");
            }
            catch (CoreException e) {
                DLTKDebugUIPlugin.log(e);
            }
        }
        return null;
    }

    protected Image getVariableImage(IScriptVariable variable) {
        return null;
    }

    protected Image getThreadImage(IScriptThread thread) {
        return null;
    }

    protected Image getStackFrameImage(IScriptStackFrame frame) {
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof IScriptBreakpoint) {
            return this.getBreakpointImage((IScriptBreakpoint)element);
        }
        if (element instanceof IScriptVariable) {
            return this.getVariableImage((IScriptVariable)element);
        }
        if (element instanceof IScriptThread) {
            return this.getThreadImage((IScriptThread)element);
        }
        if (element instanceof IScriptStackFrame) {
            return this.getStackFrameImage((IScriptStackFrame)element);
        }
        return null;
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFileHandle) {
            return new ExternalFileEditorInput((IFileHandle)element);
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            return this.getLineBreakpointEditorInput(element);
        }
        if (element instanceof IStorage) {
            return new ExternalStorageEditorInput((IStorage)element);
        }
        return null;
    }

    private IEditorInput getLineBreakpointEditorInput(Object element) {
        String location;
        ILineBreakpoint bp;
        block6: {
            bp = (ILineBreakpoint)element;
            IMarker marker = bp.getMarker();
            IResource resource = marker.getResource();
            if (resource instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            location = (String)marker.getAttribute("location");
            if (location != null) break block6;
            return null;
        }
        try {
            IPath path = Path.fromPortableString((String)location);
            String debugModelId = bp.getModelIdentifier();
            String natureId = ScriptDebugManager.getInstance().getNatureByDebugModel(debugModelId);
            IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)natureId);
            if (toolkit != null) {
                HandleFactory fac = new HandleFactory();
                IDLTKSearchScope scope = DLTKSearchScopeFactory.getInstance().createWorkspaceScope(true, toolkit);
                Openable openable = fac.createOpenable(path.toString(), scope);
                if (openable instanceof IStorage) {
                    return new ExternalStorageEditorInput((IStorage)openable);
                }
            }
        }
        catch (CoreException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return null;
    }

    public abstract String getEditorId(IEditorInput var1, Object var2);
}

