/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.transfer.spi.workspace;

import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.transfer.CDOTransferElement;
import org.eclipse.emf.cdo.transfer.CDOTransferSystem;
import org.eclipse.emf.cdo.transfer.CDOTransferType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.team.core.Team;

public class WorkspaceTransferSystem
extends CDOTransferSystem {
    public static final WorkspaceTransferSystem INSTANCE = new WorkspaceTransferSystem();
    public static final String TYPE = "workspace";
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();

    public WorkspaceTransferSystem() {
        super(false);
    }

    public String getType() {
        return TYPE;
    }

    public String getDefaultEncoding() {
        try {
            return ROOT.getDefaultCharset();
        }
        catch (CoreException ex) {
            throw WrappedException.wrap((Exception)((Object)ex));
        }
    }

    protected String getEncoding(IFile file) {
        try {
            return file.getCharset();
        }
        catch (CoreException ex) {
            throw WrappedException.wrap((Exception)((Object)ex));
        }
    }

    public CDOTransferType getDefaultTransferType(CDOTransferElement element) {
        if (element instanceof Element) {
            Element node = (Element)element;
            if (node.isDirectory()) {
                return CDOTransferType.FOLDER;
            }
            IFile file = (IFile)node.getNativeObject();
            int type = Team.getFileContentManager().getType((IStorage)file);
            switch (type) {
                case 2: {
                    return CDOTransferType.BINARY;
                }
                case 1: {
                    String encoding = this.getEncoding(file);
                    return CDOTransferType.text((String)encoding);
                }
            }
        }
        return super.getDefaultTransferType(element);
    }

    public URI getURI(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    public CDOTransferElement getElement(IPath path) {
        IResource resource = ROOT.findMember(path);
        if (resource != null && resource.exists()) {
            return new Element(this, resource);
        }
        return null;
    }

    public CDOTransferElement getElement(URI uri) {
        if (uri.isPlatformResource()) {
            IPath path = new Path(uri.path()).removeFirstSegments(1).makeAbsolute();
            return this.getElement(path);
        }
        return null;
    }

    public void createFolder(IPath path) {
        try {
            IFolder folder = ROOT.getFolder(path);
            folder.create(true, true, null);
        }
        catch (CoreException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public void createBinary(IPath path, InputStream source, IProgressMonitor monitor) {
        try {
            IFile file = ROOT.getFile(path);
            file.create(source, true, monitor);
        }
        catch (CoreException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public void createText(IPath path, InputStream source, String encoding, IProgressMonitor monitor) {
        try {
            IFile file = ROOT.getFile(path);
            file.create(source, true, monitor);
            file.setCharset(encoding, null);
        }
        catch (CoreException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public String toString() {
        return "Workspace";
    }

    private static class Element
    extends CDOTransferElement {
        private IResource resource;

        public Element(CDOTransferSystem system, IResource resource) {
            super(system);
            this.resource = resource;
        }

        public Object getNativeObject() {
            return this.resource;
        }

        public IPath getPath() {
            return this.resource.getFullPath();
        }

        public boolean isDirectory() {
            return this.resource instanceof IContainer;
        }

        protected CDOTransferElement[] doGetChildren() {
            try {
                IResource[] children = ((IContainer)this.resource).members();
                CDOTransferElement[] result = new Element[children.length];
                int i = 0;
                while (i < children.length) {
                    IResource child = children[i];
                    result[i] = new Element(this.getSystem(), child);
                    ++i;
                }
                return result;
            }
            catch (CoreException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }

        protected InputStream doOpenInputStream() {
            try {
                return ((IFile)this.resource).getContents();
            }
            catch (CoreException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
    }
}

