/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.adapt.inject;

import com.google.common.collect.MapMaker;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.common.adapt.IAdaptable;

class AdaptableScope<A extends IAdaptable>
implements Scope {
    private static Map<IAdaptable, Map<Key<?>, Object>> scopedInstances = new MapMaker().weakKeys().makeMap();
    private A adaptable = null;
    private Class<? extends A> type;

    public AdaptableScope(Class<? extends A> type) {
        this.type = type;
    }

    public void enter(A adaptable) {
        this.adaptable = adaptable;
    }

    public void leave(A adaptable) {
        this.adaptable = null;
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                Map scope;
                Object instance;
                if (AdaptableScope.this.adaptable == null) {
                    throw new IllegalStateException(key + " is scoped to adaptable '" + AdaptableScope.this.type + "', for which no scope has been activated. You can only scope adapters in a scope of a transitive adaptable.");
                }
                if (!scopedInstances.containsKey(AdaptableScope.this.adaptable)) {
                    scopedInstances.put(AdaptableScope.this.adaptable, new HashMap());
                }
                if ((instance = (scope = (Map)scopedInstances.get(AdaptableScope.this.adaptable)).get(key)) == null && (instance = unscoped.get()) != null) {
                    scope.put(key, instance);
                }
                return instance;
            }
        };
    }
}

