/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.collections;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.gef.common.collections.ListListenerHelperEx;
import org.eclipse.gef.common.collections.ObservableListWrapperEx;
import org.eclipse.gef.common.collections.ObservableMultiset;
import org.eclipse.gef.common.collections.ObservableMultisetWrapper;
import org.eclipse.gef.common.collections.ObservableSetMultimap;
import org.eclipse.gef.common.collections.ObservableSetMultimapWrapper;
import org.eclipse.gef.common.collections.UnmodifiableObservableMultisetWrapper;
import org.eclipse.gef.common.collections.UnmodifiableObservableSetMultimapWrapper;

public class CollectionUtils {
    public static <E> ObservableMultiset<E> emptyMultiset() {
        return new UnmodifiableObservableMultisetWrapper(new ObservableMultisetWrapper(HashMultiset.create()));
    }

    public static <K, V> ObservableSetMultimap<K, V> emptySetMultimap() {
        return new UnmodifiableObservableSetMultimapWrapper(new ObservableSetMultimapWrapper(HashMultimap.create()));
    }

    public static <E> int[] getPermutation(ListChangeListener.Change<? extends E> change) {
        if (!change.wasPermutated()) {
            throw new IllegalArgumentException("Change is no permutation change.");
        }
        if (change instanceof ListListenerHelperEx.AtomicChange) {
            return ((ListListenerHelperEx.AtomicChange)change).getPermutation();
        }
        int[] permutation = new int[change.getTo() - change.getFrom()];
        int oldIndex = change.getFrom();
        while (oldIndex < change.getTo()) {
            int newIndex;
            permutation[oldIndex] = newIndex = change.getPermutation(oldIndex);
            ++oldIndex;
        }
        return permutation;
    }

    public static <E> List<E> getPreviousContents(ListChangeListener.Change<E> change) {
        if (change instanceof ListListenerHelperEx.AtomicChange) {
            return ((ListListenerHelperEx.AtomicChange)change).getPreviousContents();
        }
        ObservableList currentList = change.getList();
        ObservableList previousList = FXCollections.observableArrayList((Collection)currentList);
        change.reset();
        List<ListListenerHelperEx.ElementarySubChange<E>> changes = ListListenerHelperEx.getElementaryChanges(change);
        int i = changes.size() - 1;
        while (i >= 0) {
            ListListenerHelperEx.ElementarySubChange<E> c = changes.get(i);
            int from = c.getFrom();
            int to = c.getTo();
            if (ListListenerHelperEx.ElementarySubChange.Kind.ADD.equals((Object)c.getKind()) || ListListenerHelperEx.ElementarySubChange.Kind.REPLACE.equals((Object)c.getKind())) {
                int j = to - 1;
                while (j >= from) {
                    previousList.remove(j);
                    --j;
                }
            }
            if (ListListenerHelperEx.ElementarySubChange.Kind.REMOVE.equals((Object)c.getKind()) || ListListenerHelperEx.ElementarySubChange.Kind.REPLACE.equals((Object)c.getKind())) {
                List<E> removed = c.getRemoved();
                previousList.addAll(from, removed);
            }
            if (ListListenerHelperEx.ElementarySubChange.Kind.PERMUTATE.equals((Object)c.getKind())) {
                int[] permutation = c.getPermutation();
                ArrayList<Object> subList = new ArrayList<Object>(to - from);
                int j = from;
                while (j < to) {
                    int k = permutation[j - from];
                    subList.add(currentList.get(k));
                    ++j;
                }
                previousList.remove(from, to);
                previousList.addAll(from, subList);
            }
            --i;
        }
        return previousList;
    }

    public static <E> ObservableList<E> observableArrayList() {
        return CollectionUtils.observableList(new ArrayList());
    }

    public static <E> ObservableList<E> observableArrayList(Collection<? extends E> collection) {
        ObservableList<E> list = CollectionUtils.observableArrayList();
        list.addAll(collection);
        return list;
    }

    public static <E> ObservableList<E> observableArrayList(E ... elements) {
        ObservableList<E> list = CollectionUtils.observableArrayList();
        list.addAll((Object[])elements);
        return list;
    }

    public static <K, V> ObservableSetMultimap<K, V> observableHashMultimap() {
        return CollectionUtils.observableSetMultimap(HashMultimap.create());
    }

    public static <E> ObservableMultiset<E> observableHashMultiset() {
        return CollectionUtils.observableMultiset(HashMultiset.create());
    }

    public static <E> ObservableList<E> observableList(List<E> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        return new ObservableListWrapperEx<E>(list);
    }

    public static <E> ObservableMultiset<E> observableMultiset(Multiset<E> multiset) {
        if (multiset == null) {
            throw new NullPointerException();
        }
        return new ObservableMultisetWrapper<E>(multiset);
    }

    public static <K, V> ObservableSetMultimap<K, V> observableSetMultimap(SetMultimap<K, V> setMultimap) {
        if (setMultimap == null) {
            throw new NullPointerException();
        }
        return new ObservableSetMultimapWrapper<K, V>(setMultimap);
    }

    public static <E extends Comparable<? super E>> void sort(ObservableList<E> observableList) {
        if (observableList instanceof ObservableListWrapperEx) {
            ((ObservableListWrapperEx)observableList).sort();
        } else {
            FXCollections.sort(observableList);
        }
    }

    public static <E> void sort(ObservableList<E> observableList, Comparator<? super E> comparator) {
        if (observableList instanceof ObservableListWrapperEx) {
            ((ObservableListWrapperEx)observableList).sort(comparator);
        } else {
            FXCollections.sort(observableList, comparator);
        }
    }

    public static <E> ObservableMultiset<E> unmodifiableObservableMultiset(ObservableMultiset<E> multiset) {
        if (multiset == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableObservableMultisetWrapper<E>(multiset);
    }

    public static <K, V> ObservableSetMultimap<K, V> unmodifiableObservableSetMultimap(ObservableSetMultimap<K, V> setMultimap) {
        if (setMultimap == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableObservableSetMultimapWrapper<K, V>(setMultimap);
    }
}

