/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures.GeoShapePolygonFigure;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PrecisionPointList;

public class GeoShapeHexagonFigure
extends GeoShapePolygonFigure {
    public GeoShapeHexagonFigure(int width, int height, int spacing) {
        super(width, height, spacing);
    }

    public GeoShapeHexagonFigure(int height, int spacing) {
        super((int)Math.round((double)(2 * height) / Math.sqrt(3.0)), height, spacing);
    }

    @Override
    protected PointList calculatePoints(Rectangle rect) {
        PrecisionPointList points = new PrecisionPointList();
        PrecisionPoint p1 = new PrecisionPoint(rect.preciseX() + rect.preciseWidth() - 1.0, rect.preciseY() + rect.preciseHeight() / 2.0);
        PrecisionPoint p2 = new PrecisionPoint(rect.preciseX() + 0.75 * rect.preciseWidth(), rect.preciseY());
        PrecisionPoint p3 = new PrecisionPoint(rect.preciseX() + rect.preciseWidth() / 4.0, rect.preciseY());
        PrecisionPoint p4 = new PrecisionPoint(rect.preciseX(), rect.preciseY() + rect.preciseHeight() / 2.0);
        PrecisionPoint p5 = new PrecisionPoint(p3.preciseX(), rect.preciseY() + rect.preciseHeight() - 1.0);
        PrecisionPoint p6 = new PrecisionPoint(p2.preciseX(), p5.preciseY());
        points.addPoint((Point)p1);
        points.addPoint((Point)p2);
        points.addPoint((Point)p3);
        points.addPoint((Point)p4);
        points.addPoint((Point)p5);
        points.addPoint((Point)p6);
        points.addPoint((Point)p1);
        return points;
    }
}

