/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ClipboardPlugin;

public abstract class ClipboardOperation {
    public static final int WORK_UNIT = 1;
    public static final int TOTAL_WORK = 100;
    private IProgressMonitor monitor;
    private IClipboardSupport clipboardSupport;

    public ClipboardOperation(IProgressMonitor monitor, IClipboardSupport clipboardSupport) {
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
        this.clipboardSupport = clipboardSupport;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    protected boolean isCancelled() {
        return this.getProgressMonitor().isCanceled();
    }

    public final IClipboardSupport getClipboardOperationHelper() {
        return this.clipboardSupport;
    }

    protected void catchException(String methodName, Exception ex) {
        ClipboardPlugin.catching(this.getClass(), methodName, ex);
    }

    protected void throwException(String methodName, RuntimeException ex) {
        ClipboardPlugin.throwing(this.getClass(), methodName, ex);
        throw ex;
    }

    protected void throwCancelException(String methodName) {
        this.throwException(methodName, (RuntimeException)new OperationCanceledException("Operation Canceled"));
    }
}

