/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching.sourcelookup.advanced;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.IRunnableWithProgress;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.Messages;

public class BackgroundProcessingJob
extends Job {
    private static final long EXECUTION_DELAY = 1000L;
    private final ArrayList<IRunnableWithProgress> queue = new ArrayList();

    public BackgroundProcessingJob() {
        super(Messages.BackgroundProcessingJob_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        ArrayList<IRunnableWithProgress> tasks;
        ArrayList<IRunnableWithProgress> arrayList = this.queue;
        synchronized (arrayList) {
            tasks = new ArrayList<IRunnableWithProgress>(this.queue);
            this.queue.clear();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)tasks.size());
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        for (IRunnableWithProgress task : tasks) {
            try {
                task.run((IProgressMonitor)progress.split(1));
            }
            catch (CoreException e) {
                errors.add(e.getStatus());
            }
        }
        if (errors.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (errors.size() == 1) {
            return (IStatus)errors.get(0);
        }
        return new MultiStatus("org.eclipse.jdt.launching", 4, errors.toArray(new IStatus[errors.size()]), Messages.BackgroundProcessingJob_failed, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(IRunnableWithProgress task) {
        ArrayList<IRunnableWithProgress> arrayList = this.queue;
        synchronized (arrayList) {
            this.queue.add(task);
            this.schedule(1000L);
        }
    }
}

