/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class SafeClosureWrapper<A>
implements Closure<A> {
    private final Closure<? super A> closure;
    private final ExceptionHandler exceptionHandler;

    public SafeClosureWrapper(Closure<? super A> closure, ExceptionHandler exceptionHandler) {
        if (closure == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.closure = closure;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void execute(A argument) {
        try {
            this.closure.execute(argument);
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.closure);
    }
}

