/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.predicate;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.IdentityHashSet;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.predicate.AND;
import org.eclipse.jpt.common.utility.internal.predicate.DisabledPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.Equals;
import org.eclipse.jpt.common.utility.internal.predicate.ExclusionSetPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.False;
import org.eclipse.jpt.common.utility.internal.predicate.FieldPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.InstanceOf;
import org.eclipse.jpt.common.utility.internal.predicate.IsIdentical;
import org.eclipse.jpt.common.utility.internal.predicate.IsNotNull;
import org.eclipse.jpt.common.utility.internal.predicate.IsNull;
import org.eclipse.jpt.common.utility.internal.predicate.MethodPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.NOT;
import org.eclipse.jpt.common.utility.internal.predicate.NullCheckPredicateWrapper;
import org.eclipse.jpt.common.utility.internal.predicate.OR;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateWrapper;
import org.eclipse.jpt.common.utility.internal.predicate.SetPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.TransformationPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.TransformerPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.True;
import org.eclipse.jpt.common.utility.internal.predicate.UniquePredicate;
import org.eclipse.jpt.common.utility.internal.predicate.XOR;
import org.eclipse.jpt.common.utility.predicate.CompoundPredicate;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public final class PredicateTools {
    public static final Predicate[] EMPTY_ARRAY = new Predicate[0];

    public static <V> Predicate<V> true_() {
        return True.instance();
    }

    public static <V> Predicate<V> false_() {
        return False.instance();
    }

    public static <V> Predicate<V> isNotNull() {
        return IsNotNull.instance();
    }

    public static <V> Predicate<V> isNull() {
        return IsNull.instance();
    }

    public static <V> Predicate<V> disabledPredicate() {
        return DisabledPredicate.instance();
    }

    public static <V> Predicate<V> isEqual(V criterion) {
        return new Equals<V>(criterion);
    }

    public static <V> Predicate<V> isNotEqual(V criterion) {
        return new NOT<V>(PredicateTools.isEqual(criterion));
    }

    public static <V> Predicate<V> isIdentical(V criterion) {
        return new IsIdentical<V>(criterion);
    }

    public static <V> Predicate<V> isNotIdentical(V criterion) {
        return new NOT<V>(PredicateTools.isIdentical(criterion));
    }

    public static <V> CompoundPredicate<V> and(Iterable<Predicate<? super V>> predicates) {
        return PredicateTools.and(predicates.iterator());
    }

    public static <V> CompoundPredicate<V> and(Iterator<Predicate<? super V>> predicates) {
        return PredicateTools.and(IteratorTools.toArray(predicates, EMPTY_ARRAY));
    }

    @SafeVarargs
    public static <V> CompoundPredicate<V> and(Predicate<? super V> ... predicates) {
        return new AND<V>(predicates);
    }

    public static <V> CompoundPredicate<V> or(Iterable<Predicate<? super V>> predicates) {
        return PredicateTools.or(predicates.iterator());
    }

    public static <V> CompoundPredicate<V> or(Iterator<Predicate<? super V>> predicates) {
        return PredicateTools.or(IteratorTools.toArray(predicates, EMPTY_ARRAY));
    }

    @SafeVarargs
    public static <V> CompoundPredicate<V> or(Predicate<? super V> ... predicates) {
        return new OR<V>(predicates);
    }

    public static <V> CompoundPredicate<V> xor(Predicate<? super V> predicate1, Predicate<? super V> predicate2) {
        return new XOR<V>(predicate1, predicate2);
    }

    public static <V> Predicate<V> nand(Iterable<Predicate<? super V>> predicates) {
        return PredicateTools.nand(predicates.iterator());
    }

    public static <V> Predicate<V> nand(Iterator<Predicate<? super V>> predicates) {
        return PredicateTools.nand(IteratorTools.toArray(predicates, EMPTY_ARRAY));
    }

    @SafeVarargs
    public static <V> Predicate<V> nand(Predicate<? super V> ... predicates) {
        return PredicateTools.not(PredicateTools.and(predicates));
    }

    public static <V> Predicate<V> nor(Iterable<Predicate<? super V>> predicates) {
        return PredicateTools.nor(predicates.iterator());
    }

    public static <V> Predicate<V> nor(Iterator<Predicate<? super V>> predicates) {
        return PredicateTools.nor(IteratorTools.toArray(predicates, EMPTY_ARRAY));
    }

    @SafeVarargs
    public static <V> Predicate<V> nor(Predicate<? super V> ... predicates) {
        return PredicateTools.not(PredicateTools.or(predicates));
    }

    public static <V> Predicate<V> xnor(Predicate<? super V> predicate1, Predicate<? super V> predicate2) {
        return PredicateTools.not(PredicateTools.xor(predicate1, predicate2));
    }

    public static <V> Predicate<V> not(Predicate<? super V> predicate) {
        return new NOT<V>(predicate);
    }

    public static <V> Predicate<V> nullCheck(Predicate<? super V> predicate) {
        return PredicateTools.nullCheck(predicate, false);
    }

    public static <V> Predicate<V> nullCheck(Predicate<? super V> predicate, boolean nullValue) {
        return new NullCheckPredicateWrapper<V>(predicate, nullValue);
    }

    public static <V> PredicateWrapper<V> wrap(Predicate<? super V> predicate) {
        return new PredicateWrapper<V>(predicate);
    }

    public static <I, O> Predicate<I> wrap(Predicate<? super O> predicate, Transformer<? super I, O> transformer) {
        return new TransformationPredicate<I, O>(predicate, transformer);
    }

    public static <V> Predicate<V> instanceOf(Class<? extends V> clazz) {
        return new InstanceOf<V>(clazz);
    }

    public static <V> Predicate<V> adapt(Transformer<V, Boolean> transformer) {
        return PredicateTools.adapt(transformer, false);
    }

    public static <V> Predicate<V> adapt(Transformer<V, Boolean> transformer, boolean nullValue) {
        return PredicateTools.nullCheck(PredicateTools.adapt_(transformer), nullValue);
    }

    public static <V> Predicate<V> adapt_(Transformer<V, Boolean> transformer) {
        return new TransformerPredicate<V>(transformer);
    }

    public static <V> Predicate<V> isIn(Set<? super V> set) {
        return new SetPredicate<V>(set);
    }

    public static <V> Predicate<V> isNotIn(Set<? super V> set) {
        return new ExclusionSetPredicate<V>(set);
    }

    public static <V> UniquePredicate<V> uniqueIdentityPredicate() {
        return PredicateTools.uniquePredicate(new IdentityHashSet());
    }

    public static <V> UniquePredicate<V> uniquePredicate() {
        return PredicateTools.uniquePredicate(new HashSet());
    }

    public static <V> UniquePredicate<V> uniquePredicate(Set<V> set) {
        return new UniquePredicate<V>(set);
    }

    public static <V> Predicate<V> get(String fieldName) {
        return new FieldPredicate(fieldName);
    }

    public static <V> Predicate<V> execute(String methodName) {
        return PredicateTools.execute(methodName, ClassTools.EMPTY_ARRAY, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public static <V> Predicate<V> execute(String methodName, Class<?> parameterType, Object argument) {
        return PredicateTools.execute(methodName, new Class[]{parameterType}, new Object[]{argument});
    }

    public static <V> Predicate<V> execute(String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        return new MethodPredicate(methodName, parameterTypes, arguments);
    }

    public static <V> Predicate<V>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    private PredicateTools() {
        throw new UnsupportedOperationException();
    }
}

