/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.AInterfaceTypeVRule;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class AComponentVRule
extends AInterfaceTypeVRule {
    @Override
    public Object getTarget(Object parent, Object clazz) {
        if (parent == null) {
            return null;
        }
        if ((this.isRemote() & 1) == 1) {
            return ((EnterpriseBean)parent).getRemoteInterface();
        }
        return ((EnterpriseBean)parent).getLocalInterface();
    }

    @Override
    public long getDefaultMethodType() {
        return BUSINESS;
    }

    @Override
    public long[] getBaseTypes() {
        return this.getSupertypes();
    }

    @Override
    public void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws ValidationCancelledException, InvalidInputException, ValidationException {
        if (!this.followRMI_IIOPInheritanceRules(bean, clazz)) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2468", 4, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateAppendixB(vc, bean, clazz);
    }

    @Override
    public void validate(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedLists) throws ValidationCancelledException, InvalidInputException, ValidationException {
        IMessage message;
        Method match;
        super.validate(vc, bean, clazz, method, methodsExtendedLists);
        if (this.isEJBInterfaceMethod(bean, method)) {
            IMessage message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2469", 4, bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message2);
        }
        if ((match = ValidationRuleUtility.getMethod(method, method.getName(), AComponentVRule.getBeanClassMethodsExtended(methodsExtendedLists))) == null) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2023", 1, bean, clazz, method, new String[]{method.getMethodElementSignature(), bean.getEjbClass().getJavaName()}, (IValidationRule)this);
            vc.addMessage(message);
        } else {
            IMessage message3;
            if (!ValidationRuleUtility.isAssignableFrom(method.getReturnType(), match.getReturnType())) {
                boolean addMessage = true;
                JavaClass returnType = ValidationRuleUtility.getJavaClass(method.getReturnType());
                JavaClass beanReturnType = ValidationRuleUtility.getJavaClass(match.getReturnType());
                if (returnType != null && beanReturnType != null && returnType.getKind() != TypeKind.UNDEFINED_LITERAL && beanReturnType.getKind() == TypeKind.UNDEFINED_LITERAL) {
                    JavaReflectionAdaptor adapter = (JavaReflectionAdaptor)JavaReflectionAdaptor.retrieveAdaptorFrom((EObject)bean.getEjbClass());
                    adapter.flushReflectedValuesIfNecessary(true);
                    if (ValidationRuleUtility.getMethodExtended(bean.getEjbClass(), method.getName(), method.listParametersWithoutReturn(), method.getReturnType()) != null) {
                        addMessage = false;
                    }
                }
                if (addMessage) {
                    message3 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2470", 1, bean, clazz, method, new String[]{match.getReturnType().getJavaName()}, (IValidationRule)this);
                    vc.addMessage(message3);
                }
            }
            Set exceptions = ValidationRuleUtility.getNotSubsetExceptions(bean, match, method);
            for (JavaClass exception : exceptions) {
                message3 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2471", 2, bean, clazz, method, new String[]{exception.getJavaName(), match.getMethodElementSignature()}, (IValidationRule)this);
                vc.addMessage(message3);
            }
        }
        if (!this.followRemoteExceptionRules(bean, method)) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2503.bus", this.getMessageRemoteExceptionSeverity(), bean, clazz, method, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateRMI_IIOPTypeRules(vc, bean, clazz, method, methodsExtendedLists, true);
        JavaHelpers oe = this.getOverExposedLocalType(bean, clazz, method);
        if (oe != null) {
            IMessage message4 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2472", 4, bean, clazz, method, new String[]{oe.getQualifiedName()}, (IValidationRule)this);
            vc.addMessage(message4);
        }
    }

    protected void validateAppendixB(IEJBValidationContext vc, EnterpriseBean bean, JavaClass thisComponent) {
        if (bean == null) {
            return;
        }
        EnterpriseBean supertype = this.getSuperType(bean);
        JavaClass parentComponent = null;
        if (supertype != null) {
            parentComponent = this.getComponentInterface(supertype);
            if (parentComponent == null) {
                return;
            }
            try {
                ValidationRuleUtility.isValidType((JavaHelpers)thisComponent);
                ValidationRuleUtility.isValidType((JavaHelpers)parentComponent);
                if (!ValidationRuleUtility.isAssignableFrom((JavaHelpers)thisComponent, (JavaHelpers)parentComponent)) {
                    String[] msgParm = new String[]{thisComponent.getQualifiedName(), parentComponent.getQualifiedName()};
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2105", 1, bean, thisComponent, msgParm, (IValidationRule)this);
                    vc.addMessage(message);
                }
            }
            catch (InvalidInputException e) {
                String[] msgParm = new String[]{e.getJavaClass().getQualifiedName(), bean.getName()};
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2849", 2, bean, msgParm, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }
}

