/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.List;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.AValidateEJB;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.IValidationRule;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.MessageUtility;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class AValidateHome
extends AValidateEJB {
    @Override
    public final Object getTarget(Object parent, Object clazz) {
        if (parent == null) {
            return null;
        }
        return ((EnterpriseBean)parent).getHomeInterface();
    }

    @Override
    public final List[] getMethodsExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        JavaClass beanClass = bean.getEjbClass();
        List[] result = new List[]{beanClass == null ? null : beanClass.getMethodsExtended()};
        return result;
    }

    @Override
    public final List[] getFieldsExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) {
        return null;
    }

    public Method getMatchingBeanEjbCreateMethodExtended(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return null;
        }
        if (bean == null) {
            return null;
        }
        return ValidationRuleUtility.getMethodExtended(bean.getEjbClass(), method, "ejbCreate");
    }

    @Override
    protected boolean isValid(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method, List[] methodsExtendedList) throws InvalidInputException {
        if (super.isValid(vc, bean, clazz, method, methodsExtendedList)) {
            if (ValidationRuleUtility.isEJBHomeMethod(bean, method)) {
                return false;
            }
            return !ValidationRuleUtility.isClinitMethod(bean, method);
        }
        return false;
    }

    @Override
    public void validateClass(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
        IMessage message;
        vc.terminateIfCancelled();
        if (!clazz.isInterface()) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2012", 1, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        if (!ValidationRuleUtility.isAssignableFrom((JavaHelpers)clazz, ValidationRuleUtility.getType("javax.ejb.EJBHome", bean))) {
            String[] msgParm = new String[]{"javax.ejb.EJBHome"};
            IMessage message2 = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2017", 1, bean, clazz, msgParm, (IValidationRule)this);
            vc.addMessage(message2);
        }
        if (ValidationRuleUtility.isUnnamedPackage(clazz.getJavaPackage())) {
            message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2041", 4, bean, clazz, (IValidationRule)this);
            vc.addMessage(message);
        }
        this.validateAppendixB(vc, bean, clazz);
    }

    protected void validateCreateMethod_beanDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        if (method == null) {
            return;
        }
        this.validateMatchingBeanCreateMethod(vc, bean, clazz, method);
    }

    protected void validateCreateMethod_remoteDep(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        if (method == null) {
            return;
        }
        JavaClass remoteIntf = bean.getRemoteInterface();
        ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)remoteIntf);
        if (!ValidationRuleUtility.isAssignableFrom(method.getReturnType(), (JavaHelpers)remoteIntf)) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2402", 2, bean, clazz, method, new String[]{remoteIntf.getName()}, (IValidationRule)this);
            vc.addMessage(message);
        }
    }

    public void validateMatchingBeanCreateMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) throws InvalidInputException {
        vc.terminateIfCancelled();
        if (method == null) {
            return;
        }
        JavaClass beanClass = bean.getEjbClass();
        ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)beanClass);
        Method ejbCreateMethod = ValidationRuleUtility.getMethodExtended(beanClass, method, "ejbCreate");
        if (ejbCreateMethod == null) {
            IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2026", 1, bean, clazz, method, new String[]{beanClass.getName()}, (IValidationRule)this);
            vc.addMessage(message);
            return;
        }
    }

    protected void validateAppendixB(IEJBValidationContext vc, EnterpriseBean bean, JavaClass thisHome) {
        if (bean == null) {
            return;
        }
        EnterpriseBean supertype = this.getSuperType(bean);
        JavaClass parentHome = null;
        if (supertype != null) {
            parentHome = supertype.getHomeInterface();
            try {
                ValidationRuleUtility.isValidType((JavaHelpers)thisHome);
                ValidationRuleUtility.isValidType((JavaHelpers)parentHome);
                if (ValidationRuleUtility.isAssignableFrom((JavaHelpers)thisHome, (JavaHelpers)parentHome)) {
                    String[] msgParm = new String[]{thisHome.getQualifiedName(), parentHome.getQualifiedName()};
                    IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2104", 1, bean, thisHome, msgParm, (IValidationRule)this);
                    vc.addMessage(message);
                }
            }
            catch (InvalidInputException e) {
                String[] msgParm = new String[]{e.getJavaClass().getQualifiedName(), bean.getName()};
                IMessage message = MessageUtility.getUtility().getMessage(vc, (Object)"CHKJ2849", 2, bean, msgParm, (IValidationRule)this);
                vc.addMessage(message);
            }
        }
    }
}

