/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResAuthType implements Enumerator
{
    APPLICATION_LITERAL(0, "Application", "Application"),
    CONTAINER_LITERAL(1, "Container", "Container");

    public static final int APPLICATION = 0;
    public static final int CONTAINER = 1;
    private static final ResAuthType[] VALUES_ARRAY;
    public static final List<ResAuthType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ResAuthType[]{APPLICATION_LITERAL, CONTAINER_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ResAuthType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResAuthType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResAuthType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResAuthType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResAuthType get(int value) {
        switch (value) {
            case 0: {
                return APPLICATION_LITERAL;
            }
            case 1: {
                return CONTAINER_LITERAL;
            }
        }
        return null;
    }

    private ResAuthType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

