/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.guiutils;

import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.Messages;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.SWTUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BrowserWindow
extends ApplicationWindow {
    private static final String RELOAD_ITEM_IMAGE_FILE = "reload_nav_16.gif";
    private static final String REFRESH_ITEM_IMAGE_FILE = "refresh_nav_16.gif";
    private static final String STOP_ITEM_IMAGE_FILE = "stop_nav_16.gif";
    private static final String FORWARD_ITEM_IMAGE_FILE = "forward_nav_16.gif";
    private static final String BACK_ITEM_IMAGE_FILE = "back_nav_16.gif";
    private static final int BROWSER_CMD_BACK = 1;
    private static final int BROWSER_CMD_FORWARD = 2;
    private static final int BROWSER_CMD_STOP = 3;
    private static final int BROWSER_CMD_REFRESH = 4;
    private static final int BROWSER_CMD_RELOAD = 5;
    private boolean _bIncludeToolbar;
    private boolean _bPopups;
    private String _title;
    private ScrolledComposite _scomp;
    private Composite _browserComposite;
    private Browser _browser;
    private String _startLocation;
    private String _startContent;
    private ToolItem _backItem;
    private ToolItem _forwardItem;

    public BrowserWindow(Shell parentShell) {
        this(parentShell, false, null, false);
    }

    public BrowserWindow(Shell parentShell, boolean bPopups, String title) {
        this(parentShell, bPopups, title, false);
    }

    public BrowserWindow(Shell parentShell, boolean bPopups, String title, boolean bModal) {
        super(parentShell);
        this.addStatusLine();
        this._bPopups = bPopups;
        this._title = title;
        this.includeToolbar(true);
        if (bModal && parentShell != null) {
            this.setShellStyle(this.getShellStyle() | 0x10000);
            this.setBlockOnOpen(true);
        }
    }

    public void includeToolbar(boolean bIncludeToolbar) {
        this._bIncludeToolbar = bIncludeToolbar;
    }

    public void setTitle(String title) {
        if (title != null && super.getShell() != null) {
            super.getShell().setText(title);
        }
    }

    public void setStartLocation(String startLocation) {
        this._startLocation = startLocation;
    }

    public void setStartContent(String startContent) {
        this._startContent = startContent;
    }

    public Browser getBrowser() {
        return this._browser;
    }

    protected Control createContents(Composite parent) {
        this._scomp = new ScrolledComposite(parent, 768);
        Composite innerComposite = SWTUtils.createComposite((Composite)this._scomp, 1, 10, -1);
        this._scomp.setContent((Control)innerComposite);
        ControlAdapter listener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point pt = BrowserWindow.this._scomp.getParent().getSize();
                Rectangle rect = BrowserWindow.this._browserComposite.getBounds();
                pt.x -= rect.x;
                pt.y -= rect.y;
                pt.x -= 10;
                pt.y -= 60;
                if (pt.x <= 0 || pt.y <= 0) {
                    return;
                }
                Rectangle innerRect = BrowserWindow.this._scomp.getContent().getBounds();
                Rectangle outerRect = BrowserWindow.this._scomp.getBounds();
                if (innerRect.width > outerRect.width) {
                    pt.y -= BrowserWindow.this._scomp.getHorizontalBar().getSize().y;
                }
                if (innerRect.height > outerRect.height) {
                    pt.x -= BrowserWindow.this._scomp.getVerticalBar().getSize().x;
                }
                BrowserWindow.this._browserComposite.setSize(pt);
                BrowserWindow.this._browserComposite.getParent().layout(true);
            }
        };
        this._scomp.addControlListener((ControlListener)listener);
        if (this._bIncludeToolbar) {
            ToolBar tb = new ToolBar(innerComposite, 0x800100);
            this.fillToolbar(tb);
        }
        this._browserComposite = new Composite(innerComposite, 0);
        this._browserComposite.setLayout((Layout)new FillLayout());
        this._browser = new Browser(this._browserComposite, 0);
        if (this._startLocation != null) {
            this._browser.setUrl(this._startLocation);
        } else if (this._startContent != null) {
            this._browser.setText(this._startContent);
        } else {
            this._browser.setText(Messages.BrowserWindow_loading);
        }
        this._browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                BrowserWindow.this.setStatus(event.text);
            }
        });
        if (this._bIncludeToolbar) {
            this._browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent event) {
                    BrowserWindow.this._backItem.setEnabled(BrowserWindow.this._browser.isBackEnabled());
                    BrowserWindow.this._forwardItem.setEnabled(BrowserWindow.this._browser.isForwardEnabled());
                }
            });
        }
        this._browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                if (BrowserWindow.this._bPopups) {
                    BrowserWindow window = new BrowserWindow(BrowserWindow.this.getShell());
                    window.open();
                    event.browser = window.getBrowser();
                } else {
                    event.browser = BrowserWindow.this.getBrowser();
                }
            }
        });
        this.setTitle(this._title);
        SWTUtils.computeScrollArea(this._scomp, innerComposite);
        return this._scomp;
    }

    protected void fillToolbar(ToolBar tb) {
        this._backItem = new ToolItem(tb, 8);
        this._backItem.setImage(JSFUICommonPlugin.getDefault().getImage(BACK_ITEM_IMAGE_FILE));
        this._backItem.setToolTipText(JSFUICommonPlugin.getResourceString("BrowserWindow.back.tooltip"));
        SelectionAdapter backSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserWindow.this.browserCmd(1);
            }
        };
        this._backItem.addSelectionListener((SelectionListener)backSelectionListener);
        this._forwardItem = new ToolItem(tb, 8);
        this._forwardItem.setImage(JSFUICommonPlugin.getDefault().getImage(FORWARD_ITEM_IMAGE_FILE));
        this._forwardItem.setToolTipText(JSFUICommonPlugin.getResourceString("BrowserWindow.forward.tooltip"));
        SelectionAdapter forwardSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserWindow.this.browserCmd(2);
            }
        };
        this._forwardItem.addSelectionListener((SelectionListener)forwardSelectionListener);
        ToolItem stopItem = new ToolItem(tb, 8);
        stopItem.setImage(JSFUICommonPlugin.getDefault().getImage(STOP_ITEM_IMAGE_FILE));
        stopItem.setToolTipText(JSFUICommonPlugin.getResourceString("BrowserWindow.stop.tooltip"));
        SelectionAdapter stopSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserWindow.this.browserCmd(3);
            }
        };
        stopItem.addSelectionListener((SelectionListener)stopSelectionListener);
        ToolItem refreshItem = new ToolItem(tb, 8);
        refreshItem.setImage(JSFUICommonPlugin.getDefault().getImage(REFRESH_ITEM_IMAGE_FILE));
        refreshItem.setToolTipText(JSFUICommonPlugin.getResourceString("BrowserWindow.refresh.tooltip"));
        SelectionAdapter refreshServiceSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserWindow.this.browserCmd(4);
            }
        };
        refreshItem.addSelectionListener((SelectionListener)refreshServiceSelectionListener);
        if (this._startLocation != null || this._startContent != null) {
            ToolItem reloadItem = new ToolItem(tb, 8);
            reloadItem.setImage(JSFUICommonPlugin.getDefault().getImage(RELOAD_ITEM_IMAGE_FILE));
            reloadItem.setToolTipText(JSFUICommonPlugin.getResourceString("BrowserWindow.reload.tooltip"));
            SelectionAdapter reloadSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    BrowserWindow.this.browserCmd(5);
                }
            };
            reloadItem.addSelectionListener((SelectionListener)reloadSelectionListener);
        }
    }

    public boolean browserCmd(int cmd) {
        switch (cmd) {
            case 1: {
                return this._browser.back();
            }
            case 2: {
                return this._browser.forward();
            }
            case 3: {
                this._browser.stop();
                return true;
            }
            case 4: {
                this._browser.refresh();
                return true;
            }
            case 5: {
                if (this._startLocation != null) {
                    this._browser.setUrl(this._startLocation);
                } else if (this._startContent != null) {
                    this._browser.setText(this._startContent);
                }
                return true;
            }
        }
        return false;
    }
}

