/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.threads;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;

public class TaskInfo {
    private static final String[] STATES = new String[]{Messages.TaskInfo_State_NotApplicable, Messages.TaskInfo_State_Idle, Messages.TaskInfo_State_Waiting, Messages.TaskInfo_State_Processing, Messages.TaskInfo_State_WaitingSyncIO};
    private String sequence;
    private String id;
    private String name;
    private int state;
    private LinkedList<TaskInfo> subtasks = new LinkedList();

    TaskInfo(String sequence, String id, String name, int state) {
        this.sequence = sequence;
        this.id = id;
        this.name = name != null ? name : "<>";
        this.state = state;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        if (this.state >= 0 && this.state < STATES.length) {
            return STATES[this.state];
        }
        return Messages.TaskInfo_State_NotApplicable;
    }

    public void addSubtask(TaskInfo subtask) {
        this.subtasks.addFirst(subtask);
    }

    public List<TaskInfo> getSubtasks() {
        return this.subtasks;
    }

    static class Result
    implements IResultTree {
        List<TaskInfo> tasks;

        public Result(List<TaskInfo> tasks) {
            this.tasks = tasks;
        }

        public ResultMetaData getResultMetaData() {
            return new ResultMetaData.Builder().setIsPreSortedBy(0, Column.SortDirection.DESC).build();
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.TaskInfo_Column_Number, String.class), new Column(Messages.TaskInfo_Column_Name, String.class), new Column(Messages.TaskInfo_Column_State, String.class), new Column(Messages.TaskInfo_Column_Id, String.class)};
        }

        public List<?> getElements() {
            return this.tasks;
        }

        public boolean hasChildren(Object element) {
            return !((TaskInfo)element).subtasks.isEmpty();
        }

        public List<?> getChildren(Object parent) {
            return ((TaskInfo)parent).subtasks;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            TaskInfo task = (TaskInfo)row;
            switch (columnIndex) {
                case 0: {
                    return task.getSequence();
                }
                case 1: {
                    return task.getName();
                }
                case 2: {
                    return task.getState();
                }
                case 3: {
                    return task.getId();
                }
            }
            return null;
        }

        public IContextObject getContext(Object row) {
            return null;
        }
    }
}

