/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.wildfly;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.snapshot.extension.IClassSpecificNameResolver;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.MessageUtil;

public class WildflyJbossNameResolvers {

    @Subject(value="org.jboss.modules.ModuleClassLoader")
    public static class ModuleClassLoaderResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject object) throws SnapshotException {
            IObject moduleName;
            IObject module = (IObject)object.resolveValue("module");
            if (module != null && (moduleName = (IObject)module.resolveValue("name")) != null) {
                return MessageUtil.format((String)Messages.WildflyJbossNameResolvers_ModuleClassLoaderFor, (Object[])new Object[]{moduleName.getClassSpecificName()});
            }
            return null;
        }
    }
}

