/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.ui.internal.view;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.modisco.facet.common.ui.internal.exported.views.IColumnDescription;
import org.eclipse.modisco.facet.common.ui.internal.exported.views.IElementsViewFactory;
import org.eclipse.modisco.facet.efacet.core.FacetUtils;
import org.eclipse.modisco.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.Category;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.DocumentedElement;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.modisco.facet.efacet.ui.internal.Messages;
import org.eclipse.modisco.facet.efacet.ui.internal.dialogs.FacetSetTreeContentProvider;
import org.eclipse.modisco.facet.efacet.ui.internal.utils.ImageProvider;
import org.eclipse.modisco.facet.util.emf.ui.internal.utils.ImageUtils;
import org.eclipse.swt.graphics.Image;

public class FacetSetsCatalogView
implements IExecutableExtensionFactory,
IOpenListener {
    private static final String NAME_COLUMN = "FacetView_NameColumn";
    private static final String DOCUMENTATION_COLUMN = "FacetView_LocationColumn";
    private static final String CATEGORIES_COLUMN = "FacetView_DefaultColumn";
    private static final String EXTENDS_COLUMN = "FacetView_ExtendsColumn";
    private static final int NAME_COLUMN_WIDTH = 300;
    private static final int EXTENDS_COLUMN_WIDTH = 200;
    private static final int CATEGORIES_COLUMN_WIDTH = 200;
    private static final int DOCUMENTATION_COLUMN_WIDTH = 400;

    public Object create() throws CoreException {
        ArrayList<IColumnDescription> columnDescriptions = new ArrayList<IColumnDescription>();
        columnDescriptions.add(FacetSetsCatalogView.createNameColumnDescription());
        columnDescriptions.add(FacetSetsCatalogView.createExtendsColumnDescription());
        columnDescriptions.add(FacetSetsCatalogView.createCategoriesColumnDescription());
        columnDescriptions.add(FacetSetsCatalogView.createDocumentationColumnDescription());
        return IElementsViewFactory.DEFAULT.createElementsView(columnDescriptions, FacetSetsCatalogView.getContentProvider(), FacetSetsCatalogView.getInput(), Messages.FacetSetsCatalogView_viewTitle, ImageProvider.getInstance().getFacetIcon(), (IOpenListener)this);
    }

    private static IColumnDescription createNameColumnDescription() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FacetSet) {
                    FacetSet facetSet = (FacetSet)element;
                    return facetSet.getName();
                }
                if (element instanceof Facet) {
                    Facet facet = (Facet)element;
                    return facet.getName();
                }
                if (element instanceof EStructuralFeature) {
                    EStructuralFeature feature = (EStructuralFeature)element;
                    return feature.getName();
                }
                return "";
            }

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }
        };
        return IElementsViewFactory.DEFAULT.createColumnDescription(Messages.FacetSetsCatalogView_nameColumn, NAME_COLUMN, 300, columnLabelProvider);
    }

    private static IColumnDescription createExtendsColumnDescription() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                FacetSet facetSet;
                EPackage extendedEPackage;
                String result = null;
                if (element instanceof FacetSet && (extendedEPackage = FacetUtils.getExtendedEPackage((FacetSet)(facetSet = (FacetSet)element))) != null) {
                    result = extendedEPackage.getName() + " " + extendedEPackage.getNsURI();
                }
                return result;
            }
        };
        return IElementsViewFactory.DEFAULT.createColumnDescription(Messages.FacetSetsCatalogView_extendsColumn, EXTENDS_COLUMN, 200, columnLabelProvider);
    }

    private static IColumnDescription createCategoriesColumnDescription() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                String result = null;
                if (element instanceof FacetSet) {
                    FacetSet facetSet = (FacetSet)element;
                    StringBuilder strCategories = new StringBuilder();
                    EList categories = facetSet.getCategories();
                    for (Category category : categories) {
                        if (strCategories.length() > 0) {
                            strCategories.append("; ");
                        }
                        strCategories.append(category.getName());
                    }
                    result = strCategories.toString();
                }
                return result;
            }
        };
        return IElementsViewFactory.DEFAULT.createColumnDescription(Messages.FacetSetsCatalogView_categoriesColumn, CATEGORIES_COLUMN, 200, columnLabelProvider);
    }

    private static IColumnDescription createDocumentationColumnDescription() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                String result = null;
                if (element instanceof DocumentedElement) {
                    DocumentedElement documentedElement = (DocumentedElement)element;
                    result = documentedElement.getDocumentation();
                }
                return result;
            }
        };
        return IElementsViewFactory.DEFAULT.createColumnDescription(Messages.FacetSetsCatalogView_documentationColumn, DOCUMENTATION_COLUMN, 400, columnLabelProvider);
    }

    protected static ITreeContentProvider getContentProvider() {
        return new FacetSetTreeContentProvider();
    }

    public void open(OpenEvent event) {
    }

    protected static Object getInput() {
        return IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)new ResourceSetImpl()).getRegisteredFacetSets().toArray();
    }
}

