/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.modisco.infra.common.core.internal.builder.AbstractMoDiscoCatalog;
import org.eclipse.modisco.infra.common.core.internal.builder.EcoreCatalog;
import org.eclipse.modisco.infra.common.ui.internal.Messages;
import org.eclipse.modisco.infra.common.ui.internal.util.ImageProvider;
import org.eclipse.modisco.infra.common.ui.internal.util.ImageUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class GetMoDiscoResourceDialog
extends ElementTreeSelectionDialog {
    protected static final String CATALOG_ICON_URL = "/icons/catalog.png";

    public GetMoDiscoResourceDialog(Shell parent) {
        super(parent, GetMoDiscoResourceDialog.createLabelProvider(), GetMoDiscoResourceDialog.createContentProvider());
        this.setInput(AbstractMoDiscoCatalog.getCatalogs());
        this.setTitle(Messages.GetMoDiscoResourceDialog_loadMoDiscoResource);
    }

    private static ITreeContentProvider createContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof AbstractMoDiscoCatalog) {
                    AbstractMoDiscoCatalog catalog = (AbstractMoDiscoCatalog)parentElement;
                    return catalog.getAllRootObjects().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof List) {
                    List objectList = (List)element;
                    ArrayList<AbstractMoDiscoCatalog> catalogList = new ArrayList<AbstractMoDiscoCatalog>();
                    for (Object object : objectList) {
                        if (!(object instanceof AbstractMoDiscoCatalog)) continue;
                        AbstractMoDiscoCatalog catalog = (AbstractMoDiscoCatalog)object;
                        catalogList.add(catalog);
                    }
                    return catalogList.size() > 0;
                }
                if (element instanceof AbstractMoDiscoCatalog) {
                    AbstractMoDiscoCatalog catalog = (AbstractMoDiscoCatalog)element;
                    return catalog.getAllRootObjects().size() > 0;
                }
                return false;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return AbstractMoDiscoCatalog.getCatalogs().toArray();
                }
                if (inputElement instanceof List) {
                    List objectList = (List)inputElement;
                    ArrayList<AbstractMoDiscoCatalog> catalogList = new ArrayList<AbstractMoDiscoCatalog>();
                    for (Object object : objectList) {
                        if (!(object instanceof AbstractMoDiscoCatalog) || object instanceof EcoreCatalog) continue;
                        AbstractMoDiscoCatalog catalog = (AbstractMoDiscoCatalog)object;
                        catalogList.add(catalog);
                    }
                    return catalogList.toArray(new AbstractMoDiscoCatalog[catalogList.size()]);
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private static ILabelProvider createLabelProvider() {
        return new LabelProvider(){

            public boolean isLabelProperty(Object element, String property) {
                if (element instanceof AbstractMoDiscoCatalog) {
                    return true;
                }
                return element instanceof EObject;
            }

            public String getText(Object element) {
                if (element instanceof AbstractMoDiscoCatalog) {
                    AbstractMoDiscoCatalog catalog = (AbstractMoDiscoCatalog)element;
                    return catalog.getClass().getSimpleName();
                }
                if (element instanceof EObject) {
                    EObject eObject = (EObject)element;
                    for (EAttribute eAttribute : eObject.eClass().getEAttributes()) {
                        if (!eAttribute.getName().equals("name")) continue;
                        return eObject.eGet((EStructuralFeature)eAttribute).toString();
                    }
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof AbstractMoDiscoCatalog) {
                    return ImageProvider.getInstance().getCatalogIcon();
                }
                return ImageUtils.getImage(element);
            }
        };
    }
}

