/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.layer;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.layer.AbstractIndexLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;

public class DimensionallyDependentIndexLayer
extends AbstractIndexLayerTransform {
    private IUniqueIndexLayer horizontalLayerDependency;
    private IUniqueIndexLayer verticalLayerDependency;

    public DimensionallyDependentIndexLayer(IUniqueIndexLayer baseLayer, IUniqueIndexLayer horizontalLayerDependency, IUniqueIndexLayer verticalLayerDependency) {
        super(baseLayer);
        this.setHorizontalLayerDependency(horizontalLayerDependency);
        this.setVerticalLayerDependency(verticalLayerDependency);
    }

    protected DimensionallyDependentIndexLayer(IUniqueIndexLayer baseLayer) {
        super(baseLayer);
    }

    protected void setHorizontalLayerDependency(IUniqueIndexLayer horizontalLayerDependency) {
        this.horizontalLayerDependency = horizontalLayerDependency;
    }

    protected void setVerticalLayerDependency(IUniqueIndexLayer verticalLayerDependency) {
        this.verticalLayerDependency = verticalLayerDependency;
    }

    public ILayer getHorizontalLayerDependency() {
        return this.horizontalLayerDependency;
    }

    public ILayer getVerticalLayerDependency() {
        return this.verticalLayerDependency;
    }

    public IUniqueIndexLayer getBaseLayer() {
        return this.getUnderlyingLayer();
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        ILayerCommand clonedCommand = command.cloneCommand();
        if (super.doCommand(command)) {
            return true;
        }
        clonedCommand = command.cloneCommand();
        if (this.horizontalLayerDependency.doCommand(clonedCommand)) {
            return true;
        }
        clonedCommand = command.cloneCommand();
        return this.verticalLayerDependency.doCommand(clonedCommand);
    }

    @Override
    public int getColumnCount() {
        return this.horizontalLayerDependency.getColumnCount();
    }

    @Override
    public int getPreferredColumnCount() {
        return this.horizontalLayerDependency.getPreferredColumnCount();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        return this.horizontalLayerDependency.getColumnIndexByPosition(columnPosition);
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.horizontalLayerDependency.getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        return LayerUtil.convertColumnPosition(this, localColumnPosition, this.getUnderlyingLayer());
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        return LayerUtil.convertColumnPosition(sourceUnderlyingLayer, underlyingColumnPosition, this);
    }

    @Override
    public int getWidth() {
        return this.horizontalLayerDependency.getWidth();
    }

    @Override
    public int getPreferredWidth() {
        return this.horizontalLayerDependency.getPreferredWidth();
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        return this.horizontalLayerDependency.getColumnWidthByPosition(columnPosition);
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        return this.horizontalLayerDependency.isColumnPositionResizable(columnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return this.horizontalLayerDependency.getColumnPositionByX(x);
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return this.horizontalLayerDependency.getStartXOfColumnPosition(columnPosition);
    }

    @Override
    public int getRowCount() {
        return this.verticalLayerDependency.getRowCount();
    }

    @Override
    public int getPreferredRowCount() {
        return this.verticalLayerDependency.getPreferredRowCount();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        return this.verticalLayerDependency.getRowIndexByPosition(rowPosition);
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.verticalLayerDependency.getRowPositionByIndex(rowIndex);
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        return LayerUtil.convertRowPosition(this, localRowPosition, this.getUnderlyingLayer());
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        return LayerUtil.convertRowPosition(sourceUnderlyingLayer, underlyingRowPosition, this);
    }

    @Override
    public int getHeight() {
        return this.verticalLayerDependency.getHeight();
    }

    @Override
    public int getPreferredHeight() {
        return this.verticalLayerDependency.getPreferredHeight();
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        return this.verticalLayerDependency.getRowHeightByPosition(rowPosition);
    }

    @Override
    public boolean isRowPositionResizable(int rowPosition) {
        return this.verticalLayerDependency.isRowPositionResizable(rowPosition);
    }

    @Override
    public int getRowPositionByY(int y) {
        return this.verticalLayerDependency.getRowPositionByY(y);
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        return this.verticalLayerDependency.getStartYOfRowPosition(rowPosition);
    }
}

