/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.cache;

import org.eclipse.net4j.util.cache.ICache;
import org.eclipse.net4j.util.cache.ICacheMonitor;
import org.eclipse.net4j.util.cache.ICacheRegistration;

public class CacheRegistration
implements ICacheRegistration {
    public static final float DEFAULT_RECONSTRUCTION_COST_DECAY_FACTOR = 0.1f;
    private ICacheMonitor cacheMonitor;
    private ICache cache;
    private int elementCount;
    private long cacheSize;
    private long reconstructionCost;

    public CacheRegistration(ICacheMonitor cacheMonitor, ICache cache) {
        this.cacheMonitor = cacheMonitor;
        this.cache = cache;
    }

    @Override
    public void dispose() {
        this.cacheMonitor = null;
        this.cache = null;
    }

    @Override
    public boolean isDisposed() {
        return this.cacheMonitor == null || this.cache == null;
    }

    @Override
    public ICacheMonitor getCacheMonitor() {
        return this.cacheMonitor;
    }

    @Override
    public ICache getCache() {
        return this.cache;
    }

    @Override
    public int getElementCount() {
        return this.elementCount;
    }

    @Override
    public long getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public long getAverageElementSize() {
        return this.cacheSize / (long)this.elementCount;
    }

    @Override
    public long getReconstructionCost() {
        return this.reconstructionCost;
    }

    @Override
    public void elementCached(int elementSize) {
        this.checkDisposal();
        ++this.elementCount;
        this.cacheSize += (long)elementSize;
    }

    @Override
    public void elementEvicted(int elementSize) {
        this.checkDisposal();
        --this.elementCount;
        this.cacheSize -= (long)elementSize;
    }

    @Override
    public void elementReconstructed(long reconstructionTime) {
        this.checkDisposal();
        float decayFactor = this.getReconstructionCostDecayFactor();
        this.reconstructionCost = (long)(decayFactor * (float)this.reconstructionCost + (1.0f - decayFactor) * (float)reconstructionTime);
    }

    protected float getReconstructionCostDecayFactor() {
        return 0.1f;
    }

    private void checkDisposal() {
        if (this.isDisposed()) {
            throw new IllegalStateException("disposed");
        }
    }
}

