/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <T> Iterator<T> dump(Iterator<T> it) {
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        System.out.println(list);
        return list.iterator();
    }

    public static <T> boolean addNotNull(Collection<? super T> c, T e) {
        if (e != null) {
            return c.add(e);
        }
        return false;
    }

    public static <T> Set<T> setOf(Collection<? extends T> c) {
        if (c instanceof Set) {
            return (Set)c;
        }
        return new HashSet<T>(c);
    }

    public static <T> T first(Collection<? extends T> c) {
        Iterator<T> it = c.iterator();
        return it.hasNext() ? (T)it.next() : null;
    }

    public static <K, V> List<K> removeAll(Map<K, V> map, BiPredicate<K, V> predicate) {
        ArrayList<K> keys = new ArrayList<K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V value;
            K key = entry.getKey();
            if (!predicate.test(key, value = entry.getValue())) continue;
            keys.add(key);
        }
        for (Object key : keys) {
            map.remove(key);
        }
        return keys;
    }

    public static <K, V> V compute(Map<K, V> map, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        try {
            return map.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        }
        catch (KeepMappedValue ex) {
            return (V)ex.mappedValue();
        }
    }

    public static final class KeepMappedValue
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final transient Object mappedValue;

        public KeepMappedValue(Object mappedValue) {
            this.mappedValue = mappedValue;
        }

        public <T> T mappedValue() {
            return (T)this.mappedValue;
        }
    }
}

