/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.DiagnosticComposite;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class StatusDialog
extends DiagnosticDialog {
    private final Diagnostic diagnostic;

    public StatusDialog(Shell parentShell, String dialogTitle, String message, Diagnostic diagnostic, int severityMask) {
        super(parentShell, dialogTitle, message, diagnostic, severityMask);
        this.diagnostic = diagnostic;
    }

    public StatusDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int severityMask) {
        this(parentShell, dialogTitle, message, BasicDiagnostic.toDiagnostic((IStatus)status), severityMask);
    }

    protected DiagnosticComposite createDiagnosticComposite(Composite parent) {
        DiagnosticComposite diagnosticComposite = new DiagnosticComposite(parent, 0){

            protected ILabelProvider createLabelProvider() {
                return new LabelProvider(){

                    public String getText(Object element) {
                        Diagnostic diagnostic = (Diagnostic)element;
                        String message = diagnostic.getMessage();
                        if (message == null) {
                            switch (diagnostic.getSeverity()) {
                                case 4: {
                                    message = CommonUIPlugin.getPlugin().getString("_UI_DiagnosticError_label");
                                    break;
                                }
                                case 2: {
                                    message = CommonUIPlugin.getPlugin().getString("_UI_DiagnosticWarning_label");
                                    break;
                                }
                                default: {
                                    message = CommonUIPlugin.getPlugin().getString("_UI_Diagnostic_label");
                                }
                            }
                        }
                        return message;
                    }

                    public Image getImage(Object element) {
                        Diagnostic diagnostic = (Diagnostic)element;
                        switch (diagnostic.getSeverity()) {
                            case 4: {
                                return UIPlugin.INSTANCE.getSWTImage("error");
                            }
                            case 2: 
                            case 8: {
                                return UIPlugin.INSTANCE.getSWTImage("warning");
                            }
                            case 0: 
                            case 1: {
                                return UIPlugin.INSTANCE.getSWTImage("info");
                            }
                        }
                        return null;
                    }
                };
            }
        };
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = 200;
        diagnosticComposite.setLayoutData((Object)data);
        if (this.getTextProvider() != null) {
            diagnosticComposite.setTextProvider(this.getTextProvider());
        }
        diagnosticComposite.initialize(null);
        UIUtil.asyncExec((Control)diagnosticComposite, new Runnable(){

            @Override
            public void run() {
                StatusDialog.this.setDiagnostic(StatusDialog.this.diagnostic);
            }
        });
        return diagnosticComposite;
    }
}

