/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints.util;

import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.types.constraints.AdviceConstraint;
import org.eclipse.papyrus.infra.emf.types.constraints.AnyReference;
import org.eclipse.papyrus.infra.emf.types.constraints.CompositeConstraint;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdviceConfiguration;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdvicePackage;
import org.eclipse.papyrus.infra.emf.types.constraints.ElementTypeFilter;
import org.eclipse.papyrus.infra.emf.types.constraints.ElementTypeRelationshipKind;
import org.eclipse.papyrus.infra.emf.types.constraints.EndKind;
import org.eclipse.papyrus.infra.emf.types.constraints.EndPermission;
import org.eclipse.papyrus.infra.emf.types.constraints.Reference;
import org.eclipse.papyrus.infra.emf.types.constraints.ReferenceConstraint;
import org.eclipse.papyrus.infra.emf.types.constraints.ReferenceKind;
import org.eclipse.papyrus.infra.emf.types.constraints.ReferencePermission;
import org.eclipse.papyrus.infra.emf.types.constraints.RelationshipConstraint;
import org.eclipse.papyrus.infra.emf.types.rules.container.provider.InvariantContainerRuleEditPlugin;
import org.eclipse.papyrus.infra.filters.OperatorKind;
import org.eclipse.papyrus.infra.types.AbstractAdviceBindingConfiguration;
import org.eclipse.papyrus.infra.types.util.ElementTypesConfigurationsValidator;

public class ConstraintAdviceValidator
extends EObjectValidator {
    public static final ConstraintAdviceValidator INSTANCE = new ConstraintAdviceValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.papyrus.infra.emf.types.constraints";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected ElementTypesConfigurationsValidator elementTypesConfigurationsValidator = ElementTypesConfigurationsValidator.INSTANCE;

    protected EPackage getEPackage() {
        return ConstraintAdvicePackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateConstraintAdviceConfiguration((ConstraintAdviceConfiguration)value, diagnostics, context);
            }
            case 1: {
                return this.validateAdviceConstraint((AdviceConstraint)value, diagnostics, context);
            }
            case 2: {
                return this.validateCompositeConstraint((CompositeConstraint)value, diagnostics, context);
            }
            case 3: {
                return this.validateReferenceConstraint((ReferenceConstraint)value, diagnostics, context);
            }
            case 4: {
                return this.validateReferencePermission((ReferencePermission)value, diagnostics, context);
            }
            case 5: {
                return this.validateAnyReference((AnyReference)value, diagnostics, context);
            }
            case 6: {
                return this.validateReference((Reference)value, diagnostics, context);
            }
            case 7: {
                return this.validateElementTypeFilter((ElementTypeFilter)value, diagnostics, context);
            }
            case 8: {
                return this.validateRelationshipConstraint((RelationshipConstraint)value, diagnostics, context);
            }
            case 9: {
                return this.validateEndPermission((EndPermission)value, diagnostics, context);
            }
            case 10: {
                return this.validateReferenceKind((ReferenceKind)((Object)value), diagnostics, context);
            }
            case 11: {
                return this.validateElementTypeRelationshipKind((ElementTypeRelationshipKind)((Object)value), diagnostics, context);
            }
            case 12: {
                return this.validateEndKind((EndKind)((Object)value), diagnostics, context);
            }
            case 13: {
                return this.validateEditCommandRequest((IEditCommandRequest)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateConstraintAdviceConfiguration(ConstraintAdviceConfiguration constraintAdviceConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)constraintAdviceConfiguration, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)constraintAdviceConfiguration, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)constraintAdviceConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)constraintAdviceConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)constraintAdviceConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)constraintAdviceConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)constraintAdviceConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)constraintAdviceConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)constraintAdviceConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.elementTypesConfigurationsValidator.validateAbstractAdviceBindingConfiguration_apply_to_all_types((AbstractAdviceBindingConfiguration)constraintAdviceConfiguration, diagnostics, context);
        }
        return result;
    }

    public boolean validateAdviceConstraint(AdviceConstraint adviceConstraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(adviceConstraint, diagnostics, context);
    }

    public boolean validateReferenceConstraint(ReferenceConstraint referenceConstraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(referenceConstraint, diagnostics, context);
    }

    public boolean validateReferencePermission(ReferencePermission referencePermission, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)referencePermission, diagnostics, context);
    }

    public boolean validateAnyReference(AnyReference anyReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)anyReference, diagnostics, context);
    }

    public boolean validateReference(Reference reference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)reference, diagnostics, context);
    }

    public boolean validateElementTypeFilter(ElementTypeFilter elementTypeFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)elementTypeFilter, diagnostics, context);
    }

    public boolean validateRelationshipConstraint(RelationshipConstraint relationshipConstraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(relationshipConstraint, diagnostics, context);
    }

    public boolean validateEndPermission(EndPermission endPermission, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)endPermission, diagnostics, context);
    }

    public boolean validateCompositeConstraint(CompositeConstraint compositeConstraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(compositeConstraint, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(compositeConstraint, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(compositeConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(compositeConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(compositeConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(compositeConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(compositeConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(compositeConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(compositeConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompositeConstraint_operandCount(compositeConstraint, diagnostics, context);
        }
        return result;
    }

    public boolean validateCompositeConstraint_operandCount(CompositeConstraint compositeConstraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        boolean bl = compositeConstraint.getOperator() == OperatorKind.NOT ? compositeConstraint.getConstraints().size() == 1 : (result = compositeConstraint.getConstraints().size() >= 2);
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, compositeConstraint.getOperator() == OperatorKind.NOT ? "_UI_operandCount_diagnostic_one" : "_UI_operandCount_diagnostic_atLeastTwo", new Object[]{ConstraintAdviceValidator.getObjectLabel((EObject)compositeConstraint, context)}, new Object[]{compositeConstraint, ConstraintAdvicePackage.Literals.COMPOSITE_CONSTRAINT__CONSTRAINT}, context));
        }
        return result;
    }

    public boolean validateReferenceKind(ReferenceKind referenceKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateElementTypeRelationshipKind(ElementTypeRelationshipKind elementTypeRelationshipKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateEndKind(EndKind endKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateEditCommandRequest(IEditCommandRequest editCommandRequest, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return InvariantContainerRuleEditPlugin.INSTANCE;
    }
}

