/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.processes.shell.linux;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.IService;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.processes.servicesubsystem.IProcessServiceSubSystem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.rse.subsystems.processes.shell.linux";
    public static String DONE_MARKUP_STRING = "--RSE:donedonedone:--";
    public static final String CMD_DELIMITER = ";";
    private static final String SHELL_EXIT_CMD = " exit ";
    private static final String SHELL_ECHO_CMD = " echo ";
    private static Activator plugin;
    static /* synthetic */ Class class$0;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (Activator.getDefault() == null) {
            return PLUGIN_ID;
        }
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        Activator.log((IStatus)new Status(4, Activator.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        Activator.log((IStatus)new Status(4, Activator.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public static String formatShellCommand(String cmd) {
        if (cmd == null || cmd.equals("")) {
            return cmd;
        }
        StringBuffer formattedCommand = new StringBuffer();
        formattedCommand.append(cmd).append(CMD_DELIMITER);
        formattedCommand.append(SHELL_ECHO_CMD).append(DONE_MARKUP_STRING);
        formattedCommand.append(CMD_DELIMITER).append(SHELL_EXIT_CMD);
        return formattedCommand.toString();
    }

    public static IShellService getShellService(IHost host) {
        ISubSystem ss = Activator.getSuitableSubSystem(host);
        if (ss != null) {
            IService iService = ss.getSubSystemConfiguration().getService(host);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.services.shells.IShellService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IShellService)iService.getAdapter((Class)clazz);
        }
        return null;
    }

    public static ISubSystem getSuitableSubSystem(IHost host) {
        if (host == null) {
            return null;
        }
        ISubSystem[] subSystems = host.getSubSystems();
        IShellService ssvc = null;
        int i = 0;
        while (subSystems != null && i < subSystems.length) {
            IService svc = subSystems[i].getSubSystemConfiguration().getService(host);
            if (svc != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.services.shells.IShellService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((ssvc = (IShellService)svc.getAdapter((Class)clazz)) != null) {
                    return subSystems[i];
                }
            }
            ++i;
        }
        return null;
    }

    public static IProcessServiceSubSystem getProcessServiceSubSystem(IHost host) {
        if (host == null) {
            return null;
        }
        ISubSystem[] subSystems = host.getSubSystems();
        int i = 0;
        while (subSystems != null && i < subSystems.length) {
            if (subSystems[i] instanceof IProcessServiceSubSystem) {
                return (IProcessServiceSubSystem)subSystems[i];
            }
            ++i;
        }
        return null;
    }

    public static String getErrorMessage(InputStream errStream) {
        StringBuffer errBuf = new StringBuffer();
        byte[] bytes = null;
        int numOfBytesRead = 0;
        try {
            int available = errStream.available();
            while (available > 0) {
                bytes = new byte[available];
                numOfBytesRead = errStream.read(bytes);
                if (numOfBytesRead <= -1) break;
                errBuf.append(new String(bytes, 0, numOfBytesRead));
                available = errStream.available();
            }
            return errBuf.toString();
        }
        catch (IOException e) {
            Activator.log(e);
            return null;
        }
    }
}

