/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal;

import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.core.log.ISdkConsoleSpi;
import org.eclipse.scout.sdk.core.log.LogMessage;
import org.eclipse.scout.sdk.s2e.S2ESdkActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class WorkbenchSdkConsoleSpi
implements ISdkConsoleSpi {
    public static final String CONSOLE_NAME = "Scout SDK";
    public static final String CONSOLE_TYPE = "org.eclipse.scout.sdk";

    public void clear() {
        IOConsole console = WorkbenchSdkConsoleSpi.currentConsole(false);
        if (console != null) {
            console.clearConsole();
        }
    }

    public void println(LogMessage message) {
        try (IOConsoleOutputStream out = WorkbenchSdkConsoleSpi.currentConsole(true).newOutputStream();){
            if (Level.SEVERE.equals(message.severity())) {
                out.setActivateOnWrite(true);
                WorkbenchSdkConsoleSpi.setConsoleColorRed(out);
            }
            out.write(message.all());
            out.write(System.lineSeparator());
            out.flush();
        }
        catch (IOException e) {
            System.err.println("Unable to write to console:");
            System.err.println(message.all());
            e.printStackTrace();
        }
        if (Platform.isRunning() && (Platform.inDebugMode() || Platform.inDevelopmentMode())) {
            WorkbenchSdkConsoleSpi.logToPluginLog(message);
        }
    }

    protected static void setConsoleColorRed(IOConsoleOutputStream out) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        if (display == null) {
            return;
        }
        display.syncExec(() -> out.setColor(display.getSystemColor(3)));
    }

    protected static void logToPluginLog(LogMessage message) {
        S2ESdkActivator activator = S2ESdkActivator.getDefault();
        if (activator == null) {
            return;
        }
        Status status = new Status(WorkbenchSdkConsoleSpi.julToEclipseSeverity(message.severity()), "org.eclipse.scout.sdk.s2e", message.text(), (Throwable)message.firstThrowable().orElse(null));
        activator.getLog().log((IStatus)status);
    }

    private static int julToEclipseSeverity(Level l) {
        if (l.intValue() == Level.SEVERE.intValue()) {
            return 4;
        }
        if (l.intValue() == Level.WARNING.intValue()) {
            return 2;
        }
        return 1;
    }

    public static IOConsole currentConsole(boolean autoCreate) {
        IConsoleManager mgr = ConsolePlugin.getDefault().getConsoleManager();
        IOConsole console = null;
        for (IConsole c : mgr.getConsoles()) {
            if (!CONSOLE_NAME.equals(c.getName()) || !CONSOLE_TYPE.equals(c.getType())) continue;
            if (console == null) {
                console = (IOConsole)c;
                continue;
            }
            mgr.removeConsoles(new IConsole[]{c});
        }
        if (console == null && autoCreate) {
            console = new IOConsole(CONSOLE_NAME, CONSOLE_TYPE, S2ESdkUiActivator.getImageDescriptor("eclipse_scout.gif")){

                public void clearConsole() {
                    super.clearConsole();
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
                }
            };
            mgr.addConsoles(new IConsole[]{console});
            mgr.showConsoleView((IConsole)console);
        }
        return console;
    }
}

