/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.dialogs;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.IEnumLabel;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.dialogs.SettingsStatus;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;

public abstract class AbstractSeriesSettingsDialog<T extends ISeriesSettings>
extends TitleAreaDialog {
    private AtomicReference<ComboViewer> settingStatusControl = new AtomicReference();
    private AtomicReference<Text> descriptionControl = new AtomicReference();
    private AtomicReference<Button> visibleControl = new AtomicReference();
    private AtomicReference<Button> visibleInLegendControl = new AtomicReference();
    private String title = "";
    private T settingsNormal = null;
    private T settingsHighlight = null;
    private T settingsSelected = null;

    public AbstractSeriesSettingsDialog(Shell parentShell, T settings) {
        super(parentShell);
        this.settingsNormal = settings;
        this.settingsHighlight = settings.getSeriesSettingsHighlight();
        this.settingsSelected = this.settingsNormal;
        String type = settings instanceof IBarSeriesSettings ? "Bar" : (settings instanceof ICircularSeriesSettings ? "Circular" : (settings instanceof ILineSeriesSettings ? "Line" : (settings instanceof IScatterSeriesSettings ? "Scatter" : "")));
        this.title = (String.valueOf(type) + " Series Settings").trim();
    }

    public void create() {
        super.create();
        this.setTitle(this.title);
        this.setMessage("Modify the selected series settings.");
    }

    public T getSettings() {
        return this.settingsSelected;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)this.getGridData(1808, 1));
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        this.createInputSection(composite);
        this.initialize();
        return container;
    }

    protected void createInputSection(Composite parent) {
        this.createHighlightSection(parent);
        this.createDescriptionSection(parent);
        this.createVisibleSection(parent);
        this.createVisibleInLegendSection(parent);
    }

    protected void initialize() {
        this.descriptionControl.get().setText(this.settingsSelected != null ? this.settingsSelected.getDescription() : "");
        this.visibleControl.get().setSelection(this.settingsSelected != null ? this.settingsSelected.isVisible() : false);
        this.visibleInLegendControl.get().setSelection(this.settingsSelected != null ? this.settingsSelected.isVisibleInLegend() : false);
    }

    protected Label createSectionLabel(Composite parent, String title) {
        Label label = new Label(parent, 0);
        label.setText(title);
        label.setLayoutData((Object)this.getGridData(768, 1));
        return label;
    }

    protected ComboViewer createComboViewer(Composite parent, String tooltip, IEnumLabel[] input, Object selection, GridData gridData, final Consumer<Object> consumer) {
        final ComboViewer comboViewer = new ComboViewer(parent, 8);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setInput((Object)input);
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IEnumLabel) {
                    return ((IEnumLabel)element).label();
                }
                return null;
            }
        });
        Combo combo = comboViewer.getCombo();
        combo.setToolTipText(tooltip);
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                consumer.accept(comboViewer.getStructuredSelection().getFirstElement());
            }
        });
        if (selection != null) {
            comboViewer.setSelection((ISelection)new StructuredSelection(selection));
        }
        return comboViewer;
    }

    protected Text createText(Composite parent, String title, String tooltip, GridData gridData, final Consumer<String> consumer) {
        final Text text = new Text(parent, 2048);
        text.setText(title);
        text.setToolTipText(tooltip);
        text.setLayoutData((Object)gridData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                consumer.accept(text.getText().trim());
            }
        });
        return text;
    }

    protected Text createColorChoser(Composite parent, final String title, GridData gridData, final Consumer<Color> consumer) {
        final Text text = new Text(parent, 2056);
        text.setText("");
        text.setToolTipText("");
        text.setLayoutData((Object)this.getGridData(768, 1));
        Button button = new Button(parent, 8);
        button.setText("...");
        button.setToolTipText("Select the " + title);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog colorDialog = new ColorDialog(e.display.getActiveShell());
                colorDialog.setText(title);
                RGB rgbNew = colorDialog.open();
                if (rgbNew != null) {
                    Color colorNew = ResourceSupport.getColor(rgbNew);
                    text.setBackground(colorNew);
                    consumer.accept(colorNew);
                }
            }
        });
        return text;
    }

    protected Button createCheckBox(Composite parent, String title, String tooltip, GridData gridData, final Consumer<Boolean> consumer) {
        final Button button = new Button(parent, 32);
        button.setText(title);
        button.setToolTipText(tooltip);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                consumer.accept(button.getSelection());
            }
        });
        return button;
    }

    protected Spinner createSpinner(Composite parent, String tooltip, int min, int max, int selection, GridData gridData, final Consumer<Integer> consumer) {
        final Spinner spinner = new Spinner(parent, 2048);
        spinner.setToolTipText(tooltip);
        spinner.setLayoutData((Object)gridData);
        spinner.setMinimum(min);
        spinner.setMaximum(max);
        spinner.setSelection(selection);
        spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                consumer.accept(spinner.getSelection());
            }
        });
        return spinner;
    }

    protected GridData getGridData(int style, int horizontalSpan) {
        GridData gridData = new GridData(style);
        gridData.horizontalSpan = horizontalSpan;
        return gridData;
    }

    private void createHighlightSection(Composite parent) {
        String title = "Setting Status";
        this.createSectionLabel(parent, title);
        ComboViewer comboViewer = this.createComboViewer(parent, title, SettingsStatus.values(), (Object)SettingsStatus.NORMAL, this.getGridData(768, 2), new Consumer<Object>(){

            @Override
            public void accept(Object object) {
                if (AbstractSeriesSettingsDialog.this.settingsSelected != null && object instanceof SettingsStatus) {
                    SettingsStatus settingsStatus = (SettingsStatus)((Object)object);
                    AbstractSeriesSettingsDialog.this.settingsSelected = SettingsStatus.HIGHLIGHT.equals((Object)settingsStatus) ? AbstractSeriesSettingsDialog.this.settingsHighlight : AbstractSeriesSettingsDialog.this.settingsNormal;
                    AbstractSeriesSettingsDialog.this.initialize();
                }
            }
        });
        this.settingStatusControl.set(comboViewer);
    }

    private void createDescriptionSection(Composite parent) {
        String title = "Description";
        this.createSectionLabel(parent, title);
        Text text = this.createText(parent, "", "The series description can be modified here.", this.getGridData(768, 2), new Consumer<String>(){

            @Override
            public void accept(String text) {
                if (AbstractSeriesSettingsDialog.this.settingsSelected != null) {
                    AbstractSeriesSettingsDialog.this.settingsSelected.setDescription(text);
                }
            }
        });
        this.descriptionControl.set(text);
    }

    private void createVisibleSection(Composite parent) {
        this.createSectionLabel(parent, "");
        Button button = this.createCheckBox(parent, "Visible", "Show or hide the series in the chart.", this.getGridData(768, 2), new Consumer<Boolean>(){

            @Override
            public void accept(Boolean selection) {
                if (AbstractSeriesSettingsDialog.this.settingsSelected != null) {
                    AbstractSeriesSettingsDialog.this.settingsSelected.setVisible(selection);
                }
            }
        });
        this.visibleControl.set(button);
    }

    private void createVisibleInLegendSection(Composite parent) {
        this.createSectionLabel(parent, "");
        Button button = this.createCheckBox(parent, "Visible in Legend", "Show or hide the series in the chart legend.", this.getGridData(768, 2), new Consumer<Boolean>(){

            @Override
            public void accept(Boolean selection) {
                if (AbstractSeriesSettingsDialog.this.settingsSelected != null) {
                    AbstractSeriesSettingsDialog.this.settingsSelected.setVisibleInLegend(selection);
                }
            }
        });
        this.visibleInLegendControl.set(button);
    }
}

