/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.internal.adapters;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.launch.core.internal.adapters.AttachLaunchConfigAdapter;
import org.eclipse.tcf.te.tcf.launch.core.internal.adapters.LaunchStepContext;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelLookupService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;

public class AdapterFactory
implements IAdapterFactory {
    Map<ILaunch, IStepContext> adapters = new HashMap<ILaunch, IStepContext>();
    AttachLaunchConfigAdapter attachLaunchConfigAdapter = new AttachLaunchConfigAdapter();
    private static final Class<?>[] CLASSES = new Class[]{IStepContext.class, ILaunchConfiguration.class, ILaunchConfigurationWorkingCopy.class};

    public AdapterFactory() {
        final ILaunchListener listener = new ILaunchListener(){

            public void launchRemoved(ILaunch launch) {
                IStepContext adapter = AdapterFactory.this.adapters.remove(launch);
                if (adapter instanceof IDisposable) {
                    ((IDisposable)adapter).dispose();
                }
            }

            public void launchChanged(ILaunch launch) {
                IStepContext adapter = AdapterFactory.this.adapters.remove(launch);
                if (adapter instanceof IDisposable) {
                    ((IDisposable)adapter).dispose();
                }
            }

            public void launchAdded(ILaunch launch) {
            }
        };
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DebugPlugin.getDefault().getLaunchManager().addLaunchListener(listener);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
    }

    public Object getAdapter(final Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof ILaunch) {
            if (IStepContext.class.equals((Object)adapterType)) {
                Object adapter = this.adapters.get(adaptableObject);
                if (adapter == null) {
                    adapter = new LaunchStepContext((ILaunch)adaptableObject);
                    this.adapters.put((ILaunch)adaptableObject, (IStepContext)adapter);
                }
                return adapter;
            }
        } else if (adaptableObject instanceof IPeerNode) {
            if (ILaunchConfiguration.class.equals((Object)adapterType)) {
                return this.attachLaunchConfigAdapter.getAttachLaunchConfig((IPeerNode)adaptableObject);
            }
            if (ILaunchConfigurationWorkingCopy.class.equals((Object)adapterType)) {
                ILaunchConfiguration launchConfig = this.attachLaunchConfigAdapter.getAttachLaunchConfig((IPeerNode)adaptableObject);
                try {
                    return launchConfig.getWorkingCopy();
                }
                catch (Exception e) {
                    return launchConfig;
                }
            }
        } else if (adaptableObject instanceof IPeer) {
            final IPeerModelLookupService service = (IPeerModelLookupService)ModelManager.getPeerModel().getService(IPeerModelLookupService.class);
            final AtomicReference peerNode = new AtomicReference();
            if (service != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        peerNode.set(service.lkupPeerModelById(((IPeer)adaptableObject).getID()));
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
            }
            if (peerNode.get() != null) {
                return this.getAdapter(peerNode.get(), adapterType);
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return CLASSES;
    }
}

