/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.te.ui.trees.AbstractTreeControl;
import org.eclipse.tcf.te.ui.trees.TreeViewerExtension;
import org.eclipse.tcf.te.ui.trees.ViewerDescriptor;
import org.eclipse.ui.IWorkbenchPart;

public class TreeControl
extends AbstractTreeControl {
    private String viewerId;
    private TreeViewerExtension viewerExtension;
    private ViewerDescriptor viewerDescriptor;

    public TreeControl(String viewerId) {
        this.viewerId = viewerId;
        this.initialize();
    }

    public TreeControl(String viewerId, IWorkbenchPart parentPart) {
        super(parentPart);
        this.viewerId = viewerId;
        this.initialize();
    }

    private void initialize() {
        this.viewerExtension = new TreeViewerExtension(this.viewerId);
        this.viewerDescriptor = this.viewerExtension.parseViewer();
        Assert.isNotNull((Object)this.viewerExtension);
    }

    @Override
    protected TreeViewer doCreateTreeViewer(Composite parent) {
        int style;
        Assert.isNotNull((Object)parent);
        IConfigurationElement configuration = this.viewerDescriptor.getStyleConfig();
        if (configuration != null && (style = this.viewerExtension.parseStyle(configuration)) != -1) {
            return new TreeViewer(parent, style);
        }
        return super.doCreateTreeViewer(parent);
    }

    @Override
    protected void doConfigureTreeViewer(TreeViewer viewer) {
        Transfer[] transferTypes;
        int operations;
        super.doConfigureTreeViewer(viewer);
        IConfigurationElement configuration = this.viewerDescriptor.getDragConfig();
        if (configuration != null) {
            operations = this.viewerExtension.parseDnd(configuration);
            transferTypes = this.viewerExtension.parseTransferTypes(configuration);
            DragSourceListener listener = this.viewerExtension.parseDragSourceListener(viewer, configuration);
            viewer.addDragSupport(operations, transferTypes, listener);
        }
        if ((configuration = this.viewerDescriptor.getDropConfig()) != null) {
            operations = this.viewerExtension.parseDnd(configuration);
            transferTypes = this.viewerExtension.parseTransferTypes(configuration);
            DropTargetListener adapter = this.viewerExtension.parseDropTargetListener(viewer, configuration);
            viewer.addDropSupport(operations, transferTypes, adapter);
        }
    }

    @Override
    protected String getViewerId() {
        return this.viewerId;
    }

    @Override
    protected ITreeContentProvider doCreateTreeViewerContentProvider(TreeViewer viewer) {
        return this.viewerDescriptor.getContentProvider();
    }

    @Override
    protected ISelectionChangedListener doCreateTreeViewerSelectionChangedListener(TreeViewer viewer) {
        return null;
    }

    @Override
    protected boolean isStatePersistent() {
        return this.viewerDescriptor.isPersistent();
    }

    @Override
    protected int getAutoExpandLevel() {
        return this.viewerDescriptor.getAutoExpandLevel();
    }

    @Override
    protected boolean useLabelDecorator() {
        return this.viewerDescriptor.getUseLabelDecorator();
    }
}

