/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.command.factory;

import org.eclipse.wb.core.editor.palette.model.AbstractElementInfo;
import org.eclipse.wb.internal.core.editor.palette.command.AbstractElementCommand;
import org.eclipse.wb.internal.core.editor.palette.model.entry.FactoryEntryInfo;
import org.xml.sax.Attributes;

public abstract class FactoryAbstractCommand
extends AbstractElementCommand {
    protected final String m_factoryClassName;
    protected final String m_methodSignature;
    protected final boolean m_forStatic;

    public FactoryAbstractCommand(String id, String name, String description, boolean visible, String factoryClassName, String methodSignature, boolean forStatic) {
        super(id, name, description, visible);
        this.m_factoryClassName = factoryClassName;
        this.m_methodSignature = methodSignature;
        this.m_forStatic = forStatic;
    }

    public FactoryAbstractCommand(Attributes attributes) {
        super(attributes);
        this.m_factoryClassName = attributes.getValue("class");
        this.m_methodSignature = attributes.getValue("signature");
        this.m_forStatic = "true".equals(attributes.getValue("static"));
    }

    @Override
    protected final void updateElement(AbstractElementInfo element) {
        super.updateElement(element);
        FactoryEntryInfo component = (FactoryEntryInfo)element;
        component.setFactoryClassName(this.m_factoryClassName);
        component.setMethodSignature(this.m_methodSignature);
    }

    @Override
    protected void addAttributes() {
        super.addAttributes();
        this.addAttribute("class", this.m_factoryClassName);
        this.addAttribute("signature", this.m_methodSignature);
        this.addAttribute("static", this.m_forStatic);
    }
}

