/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ast.binding;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.binding.DesignerMethodBinding;
import org.eclipse.wb.internal.core.utils.ast.binding.DesignerPackageBinding;
import org.eclipse.wb.internal.core.utils.ast.binding.DesignerTypeBinding;
import org.eclipse.wb.internal.core.utils.ast.binding.DesignerVariableBinding;

public final class BindingContext {
    private final Map<String, DesignerTypeBinding> m_typeBindings = new HashMap<String, DesignerTypeBinding>();

    public ITypeBinding get(ITypeBinding binding) {
        return this.get(binding, false);
    }

    public ITypeBinding get(ITypeBinding binding, boolean withGenerics) {
        if (binding == null) {
            return null;
        }
        Object fullyQualifiedName = AstNodeUtils.getFullyQualifiedName(binding, false, withGenerics);
        if (binding.isGenericType()) {
            fullyQualifiedName = (String)fullyQualifiedName + "_wbpGeneric";
        }
        if (binding.isAnonymous()) {
            fullyQualifiedName = (String)fullyQualifiedName + "_wbpAnonymous_" + binding.getKey();
        }
        DesignerTypeBinding designerBinding = null;
        if (!binding.isTypeVariable()) {
            designerBinding = this.m_typeBindings.get(fullyQualifiedName);
        }
        if (designerBinding == null) {
            designerBinding = new DesignerTypeBinding(this, (String)fullyQualifiedName, binding);
        }
        return designerBinding;
    }

    public DesignerTypeBinding getCopy(ITypeBinding binding) {
        return new DesignerTypeBinding(this, null, binding);
    }

    public DesignerMethodBinding get(IMethodBinding binding) {
        return new DesignerMethodBinding(this, binding);
    }

    public IVariableBinding get(IVariableBinding binding) {
        return new DesignerVariableBinding(this, binding);
    }

    public IVariableBinding get(String name, ITypeBinding declaringClass, ITypeBinding type, boolean field, int modifiers) {
        return new DesignerVariableBinding(this, name, declaringClass, type, field, modifiers);
    }

    public IPackageBinding get(IPackageBinding binding) {
        return new DesignerPackageBinding(binding);
    }

    void register(String fullyQualifiedName, DesignerTypeBinding designerBinding) {
        this.m_typeBindings.put(fullyQualifiedName, designerBinding);
    }
}

