/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraphUpdateEvent;

public class DependencyGraphEvent
implements IDependencyGraphUpdateEvent {
    private int type = 0;
    private long modStamp = 0L;
    private Map<IProject, Set<IProject>> addedReferences = null;
    private Map<IProject, Set<IProject>> removedReferences = null;

    @Override
    public int getType() {
        return this.type;
    }

    private void setType(int newType) {
        this.type = newType;
    }

    void setModStamp(long modStamp) {
        this.modStamp = modStamp;
    }

    @Override
    public long getModStamp() {
        return this.modStamp;
    }

    void addRefererence(IProject sourceProject, IProject targetProject) {
        Set<IProject> references;
        if (sourceProject == null) {
            throw new NullPointerException("Source project must not be null.");
        }
        if (targetProject == null) {
            throw new NullPointerException("Target project must not be null.");
        }
        if (this.removedReferences != null && (references = this.removedReferences.get(targetProject)) != null && references.remove(sourceProject)) {
            if (references.isEmpty()) {
                this.removedReferences.remove(targetProject);
                if (this.removedReferences.isEmpty()) {
                    this.removedReferences = null;
                    if ((this.getType() & 1) == 1) {
                        this.setType(1);
                    } else {
                        this.setType(0);
                    }
                }
            }
            return;
        }
        if (this.addedReferences == null) {
            this.setType(this.getType() | 1);
            this.addedReferences = new HashMap<IProject, Set<IProject>>();
        }
        if ((references = this.addedReferences.get(targetProject)) == null) {
            references = new HashSet<IProject>();
            this.addedReferences.put(targetProject, references);
        }
        references.add(sourceProject);
    }

    void removeReference(IProject sourceProject, IProject targetProject) {
        Set<IProject> references;
        if (sourceProject == null) {
            throw new NullPointerException("Source project must not be null.");
        }
        if (targetProject == null) {
            throw new NullPointerException("Target project must not be null.");
        }
        if (this.addedReferences != null && (references = this.addedReferences.get(targetProject)) != null && references.remove(sourceProject)) {
            if (references.isEmpty()) {
                this.addedReferences.remove(targetProject);
                if (this.addedReferences.isEmpty()) {
                    this.addedReferences = null;
                    if ((this.getType() & 2) == 2) {
                        this.setType(2);
                    } else {
                        this.setType(0);
                    }
                }
            }
            return;
        }
        if (this.removedReferences == null) {
            this.setType(this.getType() | 2);
            this.removedReferences = new HashMap<IProject, Set<IProject>>();
        }
        if ((references = this.removedReferences.get(targetProject)) == null) {
            references = new HashSet<IProject>();
            this.removedReferences.put(targetProject, references);
        }
        references.add(sourceProject);
    }

    @Override
    public Map<IProject, Set<IProject>> getAddedReferences() {
        if (this.addedReferences == null) {
            return Collections.EMPTY_MAP;
        }
        return this.addedReferences;
    }

    @Override
    public Map<IProject, Set<IProject>> getRemovedReferences() {
        if (this.removedReferences == null) {
            return Collections.EMPTY_MAP;
        }
        return this.removedReferences;
    }

    public String toString() {
        boolean removed;
        boolean added;
        StringBuffer buff = new StringBuffer("Dependency Graph Event \n{\n getModStamp() = " + this.getModStamp() + "\n hashCode() = " + this.hashCode() + "\n");
        boolean bl = added = (this.getType() & 1) == 1;
        if (added) {
            buff.append(" ADDED:\n");
            for (Map.Entry<IProject, Set<IProject>> entry : this.getAddedReferences().entrySet()) {
                buff.append("  " + entry.getKey().getName() + " -> {");
                Iterator<IProject> mappedProjects = entry.getValue().iterator();
                while (mappedProjects.hasNext()) {
                    buff.append(mappedProjects.next().getName());
                    if (!mappedProjects.hasNext()) continue;
                    buff.append(", ");
                }
                buff.append("}\n");
            }
        }
        boolean bl2 = removed = (this.getType() & 2) == 2;
        if (removed) {
            buff.append(" REMOVED:\n");
            for (Map.Entry<IProject, Set<IProject>> entry : this.getRemovedReferences().entrySet()) {
                buff.append("  " + entry.getKey().getName() + " -> {");
                Iterator<IProject> mappedProjects = entry.getValue().iterator();
                while (mappedProjects.hasNext()) {
                    buff.append(mappedProjects.next().getName());
                    if (!mappedProjects.hasNext()) continue;
                    buff.append(", ");
                }
                buff.append("}\n");
            }
        }
        buff.append("}\n");
        return buff.toString();
    }
}

