/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.search.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.core.search.SearchParticipant;
import org.eclipse.wst.common.core.search.document.Entry;
import org.eclipse.wst.common.core.search.document.SearchDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.search.XMLSearchParticipant;

public class XMLSearchDocument
extends SearchDocument {
    IDOMModel model;
    Map entries = new HashMap();

    public XMLSearchDocument(String documentPath, XMLSearchParticipant participant) {
        super(documentPath, (SearchParticipant)participant);
    }

    public Object getModel() {
        IFile file;
        if (this.model == null && (file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.getPath()))) != null) {
            try {
                this.model = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return this.model;
    }

    public Entry[] getEntries(String category, String key, int matchRule) {
        HashSet<Entry> results = new HashSet<Entry>();
        if (category != null) {
            Set values = (Set)this.entries.get(category);
            if (values == null) {
                return new Entry[0];
            }
            if (key == null || "".equals(key) || "*".equals(key)) {
                results.addAll(values);
            } else {
                for (Entry entry : values) {
                    if (!key.equals(entry.getKey())) continue;
                    results.add(entry);
                }
            }
        }
        return results.toArray(new Entry[results.size()]);
    }

    public void putEntry(Entry entry) {
        if (entry.getCategory() != null) {
            HashSet<Entry> values = (HashSet<Entry>)this.entries.get(entry.getCategory());
            if (values == null) {
                values = new HashSet<Entry>();
                this.entries.put(entry.getCategory(), values);
            }
            values.add(entry);
        }
    }

    public void dispose() {
        if (this.model != null) {
            this.model.releaseFromEdit();
        }
    }
}

