/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ContainerMount;

final class ImmutableContainerMount
implements ContainerMount {
    @Nullable
    private final String type;
    @Nullable
    private final String name;
    private final String source;
    private final String destination;
    @Nullable
    private final String driver;
    private final String mode;
    private final Boolean rw;
    @Nullable
    private final String propagation;

    private ImmutableContainerMount(@Nullable String type, @Nullable String name, String source, String destination, @Nullable String driver, String mode, Boolean rw, @Nullable String propagation) {
        this.type = type;
        this.name = name;
        this.source = source;
        this.destination = destination;
        this.driver = driver;
        this.mode = mode;
        this.rw = rw;
        this.propagation = propagation;
    }

    @Override
    @JsonProperty(value="Type")
    @Nullable
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="Name")
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Source")
    public String source() {
        return this.source;
    }

    @Override
    @JsonProperty(value="Destination")
    public String destination() {
        return this.destination;
    }

    @Override
    @JsonProperty(value="Driver")
    @Nullable
    public String driver() {
        return this.driver;
    }

    @Override
    @JsonProperty(value="Mode")
    public String mode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="RW")
    public Boolean rw() {
        return this.rw;
    }

    @Override
    @JsonProperty(value="Propagation")
    @Nullable
    public String propagation() {
        return this.propagation;
    }

    public final ImmutableContainerMount withType(@Nullable String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableContainerMount(value, this.name, this.source, this.destination, this.driver, this.mode, this.rw, this.propagation);
    }

    public final ImmutableContainerMount withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableContainerMount(this.type, value, this.source, this.destination, this.driver, this.mode, this.rw, this.propagation);
    }

    public final ImmutableContainerMount withSource(String value) {
        String newValue = Objects.requireNonNull(value, "source");
        if (this.source.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerMount(this.type, this.name, newValue, this.destination, this.driver, this.mode, this.rw, this.propagation);
    }

    public final ImmutableContainerMount withDestination(String value) {
        String newValue = Objects.requireNonNull(value, "destination");
        if (this.destination.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerMount(this.type, this.name, this.source, newValue, this.driver, this.mode, this.rw, this.propagation);
    }

    public final ImmutableContainerMount withDriver(@Nullable String value) {
        if (Objects.equals(this.driver, value)) {
            return this;
        }
        return new ImmutableContainerMount(this.type, this.name, this.source, this.destination, value, this.mode, this.rw, this.propagation);
    }

    public final ImmutableContainerMount withMode(String value) {
        String newValue = Objects.requireNonNull(value, "mode");
        if (this.mode.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerMount(this.type, this.name, this.source, this.destination, this.driver, newValue, this.rw, this.propagation);
    }

    public final ImmutableContainerMount withRw(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "rw");
        if (this.rw.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerMount(this.type, this.name, this.source, this.destination, this.driver, this.mode, newValue, this.propagation);
    }

    public final ImmutableContainerMount withPropagation(@Nullable String value) {
        if (Objects.equals(this.propagation, value)) {
            return this;
        }
        return new ImmutableContainerMount(this.type, this.name, this.source, this.destination, this.driver, this.mode, this.rw, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainerMount && this.equalTo(0, (ImmutableContainerMount)another);
    }

    private boolean equalTo(int synthetic, ImmutableContainerMount another) {
        return Objects.equals(this.type, another.type) && Objects.equals(this.name, another.name) && this.source.equals(another.source) && this.destination.equals(another.destination) && Objects.equals(this.driver, another.driver) && this.mode.equals(another.mode) && this.rw.equals(another.rw) && Objects.equals(this.propagation, another.propagation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + Objects.hashCode(this.driver);
        h += (h << 5) + this.mode.hashCode();
        h += (h << 5) + this.rw.hashCode();
        h += (h << 5) + Objects.hashCode(this.propagation);
        return h;
    }

    public String toString() {
        return "ContainerMount{type=" + this.type + ", name=" + this.name + ", source=" + this.source + ", destination=" + this.destination + ", driver=" + this.driver + ", mode=" + this.mode + ", rw=" + this.rw + ", propagation=" + this.propagation + "}";
    }

    public static ImmutableContainerMount copyOf(ContainerMount instance) {
        if (instance instanceof ImmutableContainerMount) {
            return (ImmutableContainerMount)instance;
        }
        return ImmutableContainerMount.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_SOURCE = 1L;
        private static final long INIT_BIT_DESTINATION = 2L;
        private static final long INIT_BIT_MODE = 4L;
        private static final long INIT_BIT_RW = 8L;
        private long initBits = 15L;
        private String type;
        private String name;
        private String source;
        private String destination;
        private String driver;
        private String mode;
        private Boolean rw;
        private String propagation;

        private Builder() {
        }

        public final Builder from(ContainerMount instance) {
            String nameValue;
            Objects.requireNonNull(instance, "instance");
            String typeValue = instance.type();
            if (typeValue != null) {
                this.type(typeValue);
            }
            if ((nameValue = instance.name()) != null) {
                this.name(nameValue);
            }
            this.source(instance.source());
            this.destination(instance.destination());
            String driverValue = instance.driver();
            if (driverValue != null) {
                this.driver(driverValue);
            }
            this.mode(instance.mode());
            this.rw(instance.rw());
            String propagationValue = instance.propagation();
            if (propagationValue != null) {
                this.propagation(propagationValue);
            }
            return this;
        }

        @JsonProperty(value="Type")
        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="Name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="Source")
        public final Builder source(String source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Destination")
        public final Builder destination(String destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Driver")
        public final Builder driver(@Nullable String driver) {
            this.driver = driver;
            return this;
        }

        @JsonProperty(value="Mode")
        public final Builder mode(String mode) {
            this.mode = Objects.requireNonNull(mode, "mode");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="RW")
        public final Builder rw(Boolean rw) {
            this.rw = Objects.requireNonNull(rw, "rw");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Propagation")
        public final Builder propagation(@Nullable String propagation) {
            this.propagation = propagation;
            return this;
        }

        public ImmutableContainerMount build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContainerMount(this.type, this.name, this.source, this.destination, this.driver, this.mode, this.rw, this.propagation);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("mode");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("rw");
            }
            return "Cannot build ContainerMount, some of required attributes are not set " + attributes;
        }
    }
}

