/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ContainerInfo;
import org.mandas.docker.client.messages.ExecState;
import org.mandas.docker.client.messages.ProcessConfig;

final class ImmutableExecState
implements ExecState {
    private final String id;
    private final Boolean running;
    @Nullable
    private final Long exitCode;
    private final ProcessConfig processConfig;
    private final Boolean openStdin;
    private final Boolean openStdout;
    private final Boolean openStderr;
    @Nullable
    private final ContainerInfo container;
    @Nullable
    private final String containerId;

    private ImmutableExecState(String id, Boolean running, @Nullable Long exitCode, ProcessConfig processConfig, Boolean openStdin, Boolean openStdout, Boolean openStderr, @Nullable ContainerInfo container, @Nullable String containerId) {
        this.id = id;
        this.running = running;
        this.exitCode = exitCode;
        this.processConfig = processConfig;
        this.openStdin = openStdin;
        this.openStdout = openStdout;
        this.openStderr = openStderr;
        this.container = container;
        this.containerId = containerId;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Running")
    public Boolean running() {
        return this.running;
    }

    @Override
    @JsonProperty(value="ExitCode")
    @Nullable
    public Long exitCode() {
        return this.exitCode;
    }

    @Override
    @JsonProperty(value="ProcessConfig")
    public ProcessConfig processConfig() {
        return this.processConfig;
    }

    @Override
    @JsonProperty(value="OpenStdin")
    public Boolean openStdin() {
        return this.openStdin;
    }

    @Override
    @JsonProperty(value="OpenStdout")
    public Boolean openStdout() {
        return this.openStdout;
    }

    @Override
    @JsonProperty(value="OpenStderr")
    public Boolean openStderr() {
        return this.openStderr;
    }

    @Override
    @JsonProperty(value="Container")
    @Nullable
    public ContainerInfo container() {
        return this.container;
    }

    @Override
    @JsonProperty(value="ContainerID")
    @Nullable
    public String containerId() {
        return this.containerId;
    }

    public final ImmutableExecState withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableExecState(newValue, this.running, this.exitCode, this.processConfig, this.openStdin, this.openStdout, this.openStderr, this.container, this.containerId);
    }

    public final ImmutableExecState withRunning(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "running");
        if (this.running.equals(newValue)) {
            return this;
        }
        return new ImmutableExecState(this.id, newValue, this.exitCode, this.processConfig, this.openStdin, this.openStdout, this.openStderr, this.container, this.containerId);
    }

    public final ImmutableExecState withExitCode(@Nullable Long value) {
        if (Objects.equals(this.exitCode, value)) {
            return this;
        }
        return new ImmutableExecState(this.id, this.running, value, this.processConfig, this.openStdin, this.openStdout, this.openStderr, this.container, this.containerId);
    }

    public final ImmutableExecState withProcessConfig(ProcessConfig value) {
        if (this.processConfig == value) {
            return this;
        }
        ProcessConfig newValue = Objects.requireNonNull(value, "processConfig");
        return new ImmutableExecState(this.id, this.running, this.exitCode, newValue, this.openStdin, this.openStdout, this.openStderr, this.container, this.containerId);
    }

    public final ImmutableExecState withOpenStdin(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "openStdin");
        if (this.openStdin.equals(newValue)) {
            return this;
        }
        return new ImmutableExecState(this.id, this.running, this.exitCode, this.processConfig, newValue, this.openStdout, this.openStderr, this.container, this.containerId);
    }

    public final ImmutableExecState withOpenStdout(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "openStdout");
        if (this.openStdout.equals(newValue)) {
            return this;
        }
        return new ImmutableExecState(this.id, this.running, this.exitCode, this.processConfig, this.openStdin, newValue, this.openStderr, this.container, this.containerId);
    }

    public final ImmutableExecState withOpenStderr(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "openStderr");
        if (this.openStderr.equals(newValue)) {
            return this;
        }
        return new ImmutableExecState(this.id, this.running, this.exitCode, this.processConfig, this.openStdin, this.openStdout, newValue, this.container, this.containerId);
    }

    public final ImmutableExecState withContainer(@Nullable ContainerInfo value) {
        if (this.container == value) {
            return this;
        }
        return new ImmutableExecState(this.id, this.running, this.exitCode, this.processConfig, this.openStdin, this.openStdout, this.openStderr, value, this.containerId);
    }

    public final ImmutableExecState withContainerId(@Nullable String value) {
        if (Objects.equals(this.containerId, value)) {
            return this;
        }
        return new ImmutableExecState(this.id, this.running, this.exitCode, this.processConfig, this.openStdin, this.openStdout, this.openStderr, this.container, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExecState && this.equalTo(0, (ImmutableExecState)another);
    }

    private boolean equalTo(int synthetic, ImmutableExecState another) {
        return this.id.equals(another.id) && this.running.equals(another.running) && Objects.equals(this.exitCode, another.exitCode) && this.processConfig.equals(another.processConfig) && this.openStdin.equals(another.openStdin) && this.openStdout.equals(another.openStdout) && this.openStderr.equals(another.openStderr) && Objects.equals(this.container, another.container) && Objects.equals(this.containerId, another.containerId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.running.hashCode();
        h += (h << 5) + Objects.hashCode(this.exitCode);
        h += (h << 5) + this.processConfig.hashCode();
        h += (h << 5) + this.openStdin.hashCode();
        h += (h << 5) + this.openStdout.hashCode();
        h += (h << 5) + this.openStderr.hashCode();
        h += (h << 5) + Objects.hashCode(this.container);
        h += (h << 5) + Objects.hashCode(this.containerId);
        return h;
    }

    public String toString() {
        return "ExecState{id=" + this.id + ", running=" + this.running + ", exitCode=" + this.exitCode + ", processConfig=" + this.processConfig + ", openStdin=" + this.openStdin + ", openStdout=" + this.openStdout + ", openStderr=" + this.openStderr + ", container=" + this.container + ", containerId=" + this.containerId + "}";
    }

    public static ImmutableExecState copyOf(ExecState instance) {
        if (instance instanceof ImmutableExecState) {
            return (ImmutableExecState)instance;
        }
        return ImmutableExecState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_RUNNING = 2L;
        private static final long INIT_BIT_PROCESS_CONFIG = 4L;
        private static final long INIT_BIT_OPEN_STDIN = 8L;
        private static final long INIT_BIT_OPEN_STDOUT = 16L;
        private static final long INIT_BIT_OPEN_STDERR = 32L;
        private long initBits = 63L;
        private String id;
        private Boolean running;
        private Long exitCode;
        private ProcessConfig processConfig;
        private Boolean openStdin;
        private Boolean openStdout;
        private Boolean openStderr;
        private ContainerInfo container;
        private String containerId;

        private Builder() {
        }

        public final Builder from(ExecState instance) {
            String containerIdValue;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.running(instance.running());
            Long exitCodeValue = instance.exitCode();
            if (exitCodeValue != null) {
                this.exitCode(exitCodeValue);
            }
            this.processConfig(instance.processConfig());
            this.openStdin(instance.openStdin());
            this.openStdout(instance.openStdout());
            this.openStderr(instance.openStderr());
            ContainerInfo containerValue = instance.container();
            if (containerValue != null) {
                this.container(containerValue);
            }
            if ((containerIdValue = instance.containerId()) != null) {
                this.containerId(containerIdValue);
            }
            return this;
        }

        @JsonProperty(value="ID")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Running")
        public final Builder running(Boolean running) {
            this.running = Objects.requireNonNull(running, "running");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="ExitCode")
        public final Builder exitCode(@Nullable Long exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        @JsonProperty(value="ProcessConfig")
        public final Builder processConfig(ProcessConfig processConfig) {
            this.processConfig = Objects.requireNonNull(processConfig, "processConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="OpenStdin")
        public final Builder openStdin(Boolean openStdin) {
            this.openStdin = Objects.requireNonNull(openStdin, "openStdin");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="OpenStdout")
        public final Builder openStdout(Boolean openStdout) {
            this.openStdout = Objects.requireNonNull(openStdout, "openStdout");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="OpenStderr")
        public final Builder openStderr(Boolean openStderr) {
            this.openStderr = Objects.requireNonNull(openStderr, "openStderr");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="Container")
        public final Builder container(@Nullable ContainerInfo container) {
            this.container = container;
            return this;
        }

        @JsonProperty(value="ContainerID")
        public final Builder containerId(@Nullable String containerId) {
            this.containerId = containerId;
            return this;
        }

        public ImmutableExecState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExecState(this.id, this.running, this.exitCode, this.processConfig, this.openStdin, this.openStdout, this.openStderr, this.container, this.containerId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("running");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("processConfig");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("openStdin");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("openStdout");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("openStderr");
            }
            return "Cannot build ExecState, some of required attributes are not set " + attributes;
        }
    }
}

