/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Version;

final class ImmutableVersion
implements Version {
    private final String apiVersion;
    private final String arch;
    @Nullable
    private final String buildTime;
    private final String gitCommit;
    private final String goVersion;
    private final String kernelVersion;
    private final String os;
    private final String version;

    private ImmutableVersion(String apiVersion, String arch, @Nullable String buildTime, String gitCommit, String goVersion, String kernelVersion, String os, String version) {
        this.apiVersion = apiVersion;
        this.arch = arch;
        this.buildTime = buildTime;
        this.gitCommit = gitCommit;
        this.goVersion = goVersion;
        this.kernelVersion = kernelVersion;
        this.os = os;
        this.version = version;
    }

    @Override
    @JsonProperty(value="ApiVersion")
    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="Arch")
    public String arch() {
        return this.arch;
    }

    @Override
    @JsonProperty(value="BuildTime")
    @Nullable
    public String buildTime() {
        return this.buildTime;
    }

    @Override
    @JsonProperty(value="GitCommit")
    public String gitCommit() {
        return this.gitCommit;
    }

    @Override
    @JsonProperty(value="GoVersion")
    public String goVersion() {
        return this.goVersion;
    }

    @Override
    @JsonProperty(value="KernelVersion")
    public String kernelVersion() {
        return this.kernelVersion;
    }

    @Override
    @JsonProperty(value="Os")
    public String os() {
        return this.os;
    }

    @Override
    @JsonProperty(value="Version")
    public String version() {
        return this.version;
    }

    public final ImmutableVersion withApiVersion(String value) {
        String newValue = Objects.requireNonNull(value, "apiVersion");
        if (this.apiVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableVersion(newValue, this.arch, this.buildTime, this.gitCommit, this.goVersion, this.kernelVersion, this.os, this.version);
    }

    public final ImmutableVersion withArch(String value) {
        String newValue = Objects.requireNonNull(value, "arch");
        if (this.arch.equals(newValue)) {
            return this;
        }
        return new ImmutableVersion(this.apiVersion, newValue, this.buildTime, this.gitCommit, this.goVersion, this.kernelVersion, this.os, this.version);
    }

    public final ImmutableVersion withBuildTime(@Nullable String value) {
        if (Objects.equals(this.buildTime, value)) {
            return this;
        }
        return new ImmutableVersion(this.apiVersion, this.arch, value, this.gitCommit, this.goVersion, this.kernelVersion, this.os, this.version);
    }

    public final ImmutableVersion withGitCommit(String value) {
        String newValue = Objects.requireNonNull(value, "gitCommit");
        if (this.gitCommit.equals(newValue)) {
            return this;
        }
        return new ImmutableVersion(this.apiVersion, this.arch, this.buildTime, newValue, this.goVersion, this.kernelVersion, this.os, this.version);
    }

    public final ImmutableVersion withGoVersion(String value) {
        String newValue = Objects.requireNonNull(value, "goVersion");
        if (this.goVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableVersion(this.apiVersion, this.arch, this.buildTime, this.gitCommit, newValue, this.kernelVersion, this.os, this.version);
    }

    public final ImmutableVersion withKernelVersion(String value) {
        String newValue = Objects.requireNonNull(value, "kernelVersion");
        if (this.kernelVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableVersion(this.apiVersion, this.arch, this.buildTime, this.gitCommit, this.goVersion, newValue, this.os, this.version);
    }

    public final ImmutableVersion withOs(String value) {
        String newValue = Objects.requireNonNull(value, "os");
        if (this.os.equals(newValue)) {
            return this;
        }
        return new ImmutableVersion(this.apiVersion, this.arch, this.buildTime, this.gitCommit, this.goVersion, this.kernelVersion, newValue, this.version);
    }

    public final ImmutableVersion withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableVersion(this.apiVersion, this.arch, this.buildTime, this.gitCommit, this.goVersion, this.kernelVersion, this.os, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVersion && this.equalTo(0, (ImmutableVersion)another);
    }

    private boolean equalTo(int synthetic, ImmutableVersion another) {
        return this.apiVersion.equals(another.apiVersion) && this.arch.equals(another.arch) && Objects.equals(this.buildTime, another.buildTime) && this.gitCommit.equals(another.gitCommit) && this.goVersion.equals(another.goVersion) && this.kernelVersion.equals(another.kernelVersion) && this.os.equals(another.os) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.apiVersion.hashCode();
        h += (h << 5) + this.arch.hashCode();
        h += (h << 5) + Objects.hashCode(this.buildTime);
        h += (h << 5) + this.gitCommit.hashCode();
        h += (h << 5) + this.goVersion.hashCode();
        h += (h << 5) + this.kernelVersion.hashCode();
        h += (h << 5) + this.os.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return "Version{apiVersion=" + this.apiVersion + ", arch=" + this.arch + ", buildTime=" + this.buildTime + ", gitCommit=" + this.gitCommit + ", goVersion=" + this.goVersion + ", kernelVersion=" + this.kernelVersion + ", os=" + this.os + ", version=" + this.version + "}";
    }

    public static ImmutableVersion copyOf(Version instance) {
        if (instance instanceof ImmutableVersion) {
            return (ImmutableVersion)instance;
        }
        return ImmutableVersion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_API_VERSION = 1L;
        private static final long INIT_BIT_ARCH = 2L;
        private static final long INIT_BIT_GIT_COMMIT = 4L;
        private static final long INIT_BIT_GO_VERSION = 8L;
        private static final long INIT_BIT_KERNEL_VERSION = 16L;
        private static final long INIT_BIT_OS = 32L;
        private static final long INIT_BIT_VERSION = 64L;
        private long initBits = 127L;
        private String apiVersion;
        private String arch;
        private String buildTime;
        private String gitCommit;
        private String goVersion;
        private String kernelVersion;
        private String os;
        private String version;

        private Builder() {
        }

        public final Builder from(Version instance) {
            Objects.requireNonNull(instance, "instance");
            this.apiVersion(instance.apiVersion());
            this.arch(instance.arch());
            String buildTimeValue = instance.buildTime();
            if (buildTimeValue != null) {
                this.buildTime(buildTimeValue);
            }
            this.gitCommit(instance.gitCommit());
            this.goVersion(instance.goVersion());
            this.kernelVersion(instance.kernelVersion());
            this.os(instance.os());
            this.version(instance.version());
            return this;
        }

        @JsonProperty(value="ApiVersion")
        public final Builder apiVersion(String apiVersion) {
            this.apiVersion = Objects.requireNonNull(apiVersion, "apiVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Arch")
        public final Builder arch(String arch) {
            this.arch = Objects.requireNonNull(arch, "arch");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="BuildTime")
        public final Builder buildTime(@Nullable String buildTime) {
            this.buildTime = buildTime;
            return this;
        }

        @JsonProperty(value="GitCommit")
        public final Builder gitCommit(String gitCommit) {
            this.gitCommit = Objects.requireNonNull(gitCommit, "gitCommit");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="GoVersion")
        public final Builder goVersion(String goVersion) {
            this.goVersion = Objects.requireNonNull(goVersion, "goVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="KernelVersion")
        public final Builder kernelVersion(String kernelVersion) {
            this.kernelVersion = Objects.requireNonNull(kernelVersion, "kernelVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="Os")
        public final Builder os(String os) {
            this.os = Objects.requireNonNull(os, "os");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="Version")
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableVersion build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVersion(this.apiVersion, this.arch, this.buildTime, this.gitCommit, this.goVersion, this.kernelVersion, this.os, this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("apiVersion");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("arch");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("gitCommit");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("goVersion");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("kernelVersion");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("os");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build Version, some of required attributes are not set " + attributes;
        }
    }
}

