/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.io.FileSystemItem;

public interface SourceGenerator
extends Serializable {
    public String make();

    default public <F> String _toString() {
        return this.make();
    }

    default public FileSystemItem serializeToPath(String absolutePath) {
        return StaticComponentContainer.Objects.serializeToPath(this, absolutePath);
    }

    public static <S extends SourceGenerator> S deserializeFromPath(String absolutePath) {
        return (S)((SourceGenerator)StaticComponentContainer.Objects.deserializeFromPath(absolutePath));
    }

    default public void serialize(OutputStream outputStream) {
        StaticComponentContainer.Objects.serialize(this, outputStream);
    }

    public static <S extends SourceGenerator> S deserialize(InputStream inputStream) {
        return (S)((SourceGenerator)StaticComponentContainer.Objects.deserialize(inputStream));
    }

    public static abstract class Abst
    implements SourceGenerator {
        private static final long serialVersionUID = -6189371616365377165L;
        static final String EMPTY_SPACE = " ";
        static final String COMMA = ",";
        static final String SEMICOLON = ";";

        public String toString() {
            return this.make();
        }

        String getOrEmpty(SourceGenerator value) {
            return Optional.ofNullable(value.make()).orElseGet(() -> "");
        }

        String getOrEmpty(String value) {
            return Optional.ofNullable(value).orElseGet(() -> "");
        }

        String getOrEmpty(Object ... values) {
            return this.getOrEmpty(Arrays.asList(values));
        }

        String getOrEmpty(Collection<?> objects) {
            return this.getOrEmpty(objects, EMPTY_SPACE);
        }

        String getOrEmpty(Collection<?> objects, String separator) {
            String value = "";
            objects = Optional.ofNullable(objects).map(objs -> new ArrayList(objs)).orElseGet(ArrayList::new);
            objects.removeAll(Collections.singleton(null));
            objects.removeAll(Collections.singleton(""));
            Iterator objectsItr = objects.iterator();
            while (objectsItr.hasNext()) {
                Object object = objectsItr.next();
                if (object instanceof SourceGenerator) {
                    value = value + this.getOrEmpty((SourceGenerator)object);
                } else if (object instanceof String) {
                    value = value + this.getOrEmpty((String)object);
                } else if (object instanceof Collection) {
                    value = value + this.getOrEmpty((Collection)object, separator);
                }
                if (!objectsItr.hasNext() || value.endsWith("\t") || value.endsWith("\n")) continue;
                value = value + separator;
            }
            return value;
        }
    }
}

