/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.commands;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.IReverseResumeHandler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.AbstractDebugCommand;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;

public class GdbReverseResumeCommand
extends AbstractDebugCommand
implements IReverseResumeHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public GdbReverseResumeCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    protected void doExecute(Object[] targets, IProgressMonitor monitor, IRequest request) throws CoreException {
        if (targets.length != 1) {
            return;
        }
        final IRunControl.IExecutionDMContext dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)targets[0]).getDMContext(), IRunControl.IExecutionDMContext.class);
        if (dmc == null) {
            return;
        }
        Query<Object> reverseResume = new Query<Object>(){

            public void execute(DataRequestMonitor<Object> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbReverseResumeCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.reverseResume(dmc, rm);
                } else {
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)reverseResume);
            reverseResume.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    protected boolean isExecutable(Object[] targets, IProgressMonitor monitor, IEnabledStateRequest request) throws CoreException {
        if (targets.length != 1) {
            return false;
        }
        final IRunControl.IExecutionDMContext dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)targets[0]).getDMContext(), IRunControl.IExecutionDMContext.class);
        if (dmc == null) {
            return false;
        }
        Query<Boolean> canReverseResume = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbReverseResumeCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.canReverseResume(dmc, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canReverseResume);
            return (Boolean)canReverseResume.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return false;
    }

    protected Object getTarget(Object element) {
        if (element instanceof IDMVMContext) {
            return element;
        }
        return null;
    }

    protected boolean isRemainEnabled(IDebugCommandRequest request) {
        return false;
    }
}

