/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.config;

import java.net.URI;
import java.util.Optional;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.lsp.ExistingResource;
import org.eclipse.cdt.lsp.clangd.ClangdFallbackFlags;
import org.eclipse.cdt.lsp.editor.InitialUri;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public final class ClangdFallbackManager
implements ClangdFallbackFlags {
    private static final String ISYSTEM = "-isystem";
    private final boolean isWindows = "win32".equals(Platform.getOS());
    @Reference
    private ICBuildConfigurationManager build;
    @Reference
    private InitialUri uri;
    @Reference
    private IWorkspace workspace;

    @Override
    public FallbackFlags getFallbackFlagsFromInitialUri(URI root) {
        if (this.isWindows) {
            return this.uri.find(root).flatMap(new ExistingResource(this.workspace)).flatMap(this::flags).orElse(null);
        }
        return null;
    }

    private Optional<FallbackFlags> flags(IResource initial) {
        return this.buildConfiguration(initial).map(bc -> bc.getScannerInformation(initial)).map(IScannerInfo::getIncludePaths).map(stringArray -> new FallbackFlags((String[])stringArray));
    }

    private Optional<ICBuildConfiguration> buildConfiguration(IResource initial) {
        try {
            IBuildConfiguration active = initial.getProject().getActiveBuildConfig();
            if (active != null) {
                return Optional.ofNullable(this.build.getBuildConfiguration(active));
            }
        }
        catch (CoreException e) {
            Platform.getLog(ClangdFallbackManager.class).error(e.getMessage(), (Throwable)e);
        }
        return Optional.empty();
    }

    class FallbackFlags {
        final String[] fallbackFlags;

        FallbackFlags(String[] systemIncludes) {
            if (systemIncludes != null) {
                this.fallbackFlags = new String[systemIncludes.length];
                int i = 0;
                while (i < systemIncludes.length) {
                    this.fallbackFlags[i] = ClangdFallbackManager.ISYSTEM.concat(systemIncludes[i]);
                    ++i;
                }
            } else {
                this.fallbackFlags = null;
            }
        }
    }
}

