/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.java;

import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.dstore.core.java.IClassByteStreamHandler;
import org.eclipse.dstore.core.java.IRemoteClassInstance;
import org.eclipse.dstore.core.java.RemoteClassLoader;
import org.eclipse.dstore.core.java.RemoteObjectInputStream;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;

public class ClassByteStreamHandler
implements IClassByteStreamHandler {
    protected DataStore _dataStore;
    protected DataElement _log;
    protected static final String FILEMSG_REMOTE_SAVE_FAILED = "RSEF5006";

    public ClassByteStreamHandler(DataStore dataStore, DataElement log) {
        this._dataStore = dataStore;
        this._log = log;
    }

    public String getIdentifier() {
        return this.getClass().getName();
    }

    public void receiveBytes(String className, byte[] buffer, int size) {
        ReceiveClassThread rct = new ReceiveClassThread(className, buffer, size);
        rct.start();
    }

    public void receiveInstanceBytes(byte[] buffer, int size) {
        ReceiveClassInstanceThread rct = new ReceiveClassInstanceThread(buffer, size);
        rct.start();
    }

    protected DataElement findStatusFor(String remotePath) {
        if (this._log != null) {
            int i = 0;
            while (i < this._log.getNestedSize()) {
                DataElement child = this._log.get(i);
                if (child.getName().equals(remotePath)) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    protected class ReceiveClassInstanceThread
    extends Thread {
        private byte[] _buffer;
        private int _size;

        public ReceiveClassInstanceThread(byte[] buffer, int size) {
            this._buffer = buffer;
            this._size = size;
        }

        public void run() {
            ClassByteStreamHandler.this._dataStore.trace("receiving class bytes");
            ClassByteStreamHandler.this._dataStore.trace("\tsize=" + this._size);
            ClassByteStreamHandler.this._dataStore.trace("\tbuffer=" + this._buffer);
            try {
                PipedInputStream ins = new PipedInputStream();
                PipedOutputStream outStream = new PipedOutputStream(ins);
                outStream.write(this._buffer, 0, this._size);
                outStream.flush();
                outStream.close();
                IRemoteClassInstance instance = this.loadInstance(ins);
                if (instance != null) {
                    ClassByteStreamHandler.this._dataStore.trace("running class instance " + instance);
                    this.runInstance(instance);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected IRemoteClassInstance loadInstance(InputStream ins) {
            RemoteObjectInputStream inStream = null;
            try {
                inStream = new RemoteObjectInputStream(ins, ClassByteStreamHandler.this._dataStore.getRemoteClassLoader());
                return (IRemoteClassInstance)inStream.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        protected void runInstance(IRemoteClassInstance instance) {
            if (ClassByteStreamHandler.this._dataStore.isVirtual()) {
                instance.updatedOnClient();
            } else {
                ClassByteStreamHandler.this._dataStore.trace("calling arrived on server");
                try {
                    instance.arrivedOnServer();
                }
                catch (Exception e) {
                    ClassByteStreamHandler.this._dataStore.trace(e);
                }
                ClassByteStreamHandler.this._dataStore.updateRemoteClassInstance(instance, ClassByteStreamHandler.this.getIdentifier());
            }
        }
    }

    protected class ReceiveClassThread
    extends Thread {
        private String _className;
        private byte[] _buffer;
        private int _size;

        public ReceiveClassThread(String className, byte[] buffer, int size) {
            this._className = className;
            this._buffer = buffer;
            this._size = size;
        }

        public void run() {
            RemoteClassLoader remoteLoader = new RemoteClassLoader(ClassByteStreamHandler.this._dataStore);
            remoteLoader.receiveClass(this._className, this._buffer, this._size);
        }
    }
}

