/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.AccessibleHandleProvider;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeListener;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.accessibility.AccessibleControlEvent;

public abstract class AbstractGraphicalEditPart
extends AbstractEditPart
implements GraphicalEditPart {
    protected IFigure figure;
    protected List<ConnectionEditPart> sourceConnections;
    protected List<ConnectionEditPart> targetConnections;

    @Override
    public void activate() {
        super.activate();
        this.getSourceConnections().forEach(EditPart::activate);
    }

    @Override
    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getContentPane().add(child, index);
    }

    @Override
    public void addNodeListener(NodeListener listener) {
        this.eventListeners.addListener(NodeListener.class, (Object)listener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getSourceConnections().forEach(conn -> conn.setSource(this));
        this.getTargetConnections().forEach(conn -> conn.setTarget(this));
    }

    protected void addSourceConnection(ConnectionEditPart connection, int index) {
        this.primAddSourceConnection(connection, index);
        GraphicalEditPart source = (GraphicalEditPart)connection.getSource();
        if (source != null) {
            source.getSourceConnections().remove(connection);
        }
        connection.setSource(this);
        if (this.isActive()) {
            connection.activate();
        }
        this.fireSourceConnectionAdded(connection, index);
    }

    protected void addTargetConnection(ConnectionEditPart connection, int index) {
        this.primAddTargetConnection(connection, index);
        GraphicalEditPart target = (GraphicalEditPart)connection.getTarget();
        if (target != null) {
            target.getTargetConnections().remove(connection);
        }
        connection.setTarget(this);
        this.fireTargetConnectionAdded(connection, index);
    }

    protected ConnectionEditPart createConnection(Object model) {
        return (ConnectionEditPart)this.getViewer().getEditPartFactory().createEditPart(this, model);
    }

    protected abstract IFigure createFigure();

    protected ConnectionEditPart createOrFindConnection(Object model) {
        EditPart editPart = this.getViewer().getEditPartForModel(model);
        if (editPart instanceof ConnectionEditPart) {
            ConnectionEditPart conx = (ConnectionEditPart)editPart;
            return conx;
        }
        return this.createConnection(model);
    }

    @Override
    public void deactivate() {
        this.getSourceConnections().forEach(EditPart::deactivate);
        super.deactivate();
    }

    protected void fireRemovingSourceConnection(ConnectionEditPart connection, int index) {
        if (this.eventListeners == null) {
            return;
        }
        this.eventListeners.getListenersIterable(NodeListener.class).forEach(lst -> lst.removingSourceConnection(connection, index));
    }

    protected void fireRemovingTargetConnection(ConnectionEditPart connection, int index) {
        if (this.eventListeners == null) {
            return;
        }
        this.eventListeners.getListenersIterable(NodeListener.class).forEach(lst -> lst.removingTargetConnection(connection, index));
    }

    protected void fireSourceConnectionAdded(ConnectionEditPart connection, int index) {
        if (this.eventListeners == null) {
            return;
        }
        this.eventListeners.getListenersIterable(NodeListener.class).forEach(lst -> lst.sourceConnectionAdded(connection, index));
    }

    protected void fireTargetConnectionAdded(ConnectionEditPart connection, int index) {
        if (this.eventListeners == null) {
            return;
        }
        this.eventListeners.getListenersIterable(NodeListener.class).forEach(lst -> lst.targetConnectionAdded(connection, index));
    }

    @Override
    public <T> T getAdapter(Class<T> key) {
        if (key == AccessibleHandleProvider.class) {
            return key.cast(new MergedAccessibleHandles(this.getEditPolicyIterable()));
        }
        if (key == AccessibleAnchorProvider.class) {
            return key.cast(new DefaultAccessibleAnchorProvider());
        }
        return super.getAdapter(key);
    }

    @Override
    public List<? extends GraphicalEditPart> getChildren() {
        return super.getChildren();
    }

    @Override
    public IFigure getContentPane() {
        return this.getFigure();
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTracker(this);
    }

    @Override
    public IFigure getFigure() {
        if (this.figure == null) {
            this.setFigure(this.createFigure());
        }
        return this.figure;
    }

    protected IFigure getLayer(Object layer) {
        return LayerManager.Helper.find(this).getLayer(layer);
    }

    protected List getModelSourceConnections() {
        return Collections.EMPTY_LIST;
    }

    protected List getModelTargetConnections() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<? extends ConnectionEditPart> getSourceConnections() {
        if (this.sourceConnections == null) {
            return Collections.emptyList();
        }
        return this.sourceConnections;
    }

    @Override
    public List<? extends ConnectionEditPart> getTargetConnections() {
        if (this.targetConnections == null) {
            return Collections.emptyList();
        }
        return this.targetConnections;
    }

    @Override
    public boolean isSelectable() {
        return super.isSelectable() && this.getFigure() != null && this.getFigure().isShowing();
    }

    protected void primAddSourceConnection(ConnectionEditPart connection, int index) {
        if (this.sourceConnections == null) {
            this.sourceConnections = new ArrayList<ConnectionEditPart>();
        }
        this.sourceConnections.add(index, connection);
    }

    protected void primAddTargetConnection(ConnectionEditPart connection, int index) {
        if (this.targetConnections == null) {
            this.targetConnections = new ArrayList<ConnectionEditPart>();
        }
        this.targetConnections.add(index, connection);
    }

    protected void primRemoveSourceConnection(ConnectionEditPart connection) {
        this.sourceConnections.remove(connection);
    }

    protected void primRemoveTargetConnection(ConnectionEditPart connection) {
        this.targetConnections.remove(connection);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshSourceConnections();
        this.refreshTargetConnections();
    }

    protected void refreshSourceConnections() {
        List<? extends ConnectionEditPart> sourceConns = this.getSourceConnections();
        Map<Object, ConnectionEditPart> modelToEditPart = sourceConns.stream().collect(Collectors.toMap(EditPart::getModel, cEP -> cEP));
        List modelObjects = this.getModelSourceConnections();
        if (modelObjects == null) {
            modelObjects = Collections.emptyList();
        }
        int i = 0;
        while (i < modelObjects.size()) {
            Object model = modelObjects.get(i);
            if (i >= sourceConns.size() || sourceConns.get(i).getModel() != model) {
                ConnectionEditPart editPart = modelToEditPart.get(model);
                if (editPart != null) {
                    this.reorderSourceConnection(editPart, i);
                } else {
                    this.addSourceConnection(this.createOrFindConnection(model), i);
                }
            }
            ++i;
        }
        int size = sourceConns.size();
        if (i < size) {
            ArrayList<ConnectionEditPart> trash = new ArrayList<ConnectionEditPart>(size - i);
            while (i < size) {
                trash.add(sourceConns.get(i));
                ++i;
            }
            trash.forEach(this::removeSourceConnection);
        }
    }

    protected void refreshTargetConnections() {
        List<? extends ConnectionEditPart> targetConns = this.getTargetConnections();
        Map<Object, ConnectionEditPart> modelToEditPart = targetConns.stream().collect(Collectors.toMap(EditPart::getModel, cEP -> cEP));
        List modelObjects = this.getModelTargetConnections();
        if (modelObjects == null) {
            modelObjects = Collections.emptyList();
        }
        int i = 0;
        while (i < modelObjects.size()) {
            Object model = modelObjects.get(i);
            if (i >= targetConns.size() || ((EditPart)targetConns.get(i)).getModel() != model) {
                ConnectionEditPart editPart = modelToEditPart.get(model);
                if (editPart != null) {
                    this.reorderTargetConnection(editPart, i);
                } else {
                    this.addTargetConnection(this.createOrFindConnection(model), i);
                }
            }
            ++i;
        }
        int size = targetConns.size();
        if (i < size) {
            ArrayList<ConnectionEditPart> trash = new ArrayList<ConnectionEditPart>(size - i);
            while (i < size) {
                trash.add(targetConns.get(i));
                ++i;
            }
            trash.forEach(this::removeTargetConnection);
        }
    }

    @Override
    protected void registerVisuals() {
        this.getViewer().getVisualPartMap().put(this.getFigure(), this);
    }

    @Override
    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getContentPane().remove(child);
    }

    @Override
    public void removeNodeListener(NodeListener listener) {
        this.eventListeners.removeListener(NodeListener.class, (Object)listener);
    }

    @Override
    public void removeNotify() {
        this.getSourceConnections().stream().filter(conn -> conn.getSource() == this).forEach(conn -> conn.setSource(null));
        this.getTargetConnections().stream().filter(conn -> conn.getTarget() == this).forEach(conn -> conn.setTarget(null));
        super.removeNotify();
    }

    protected void removeSourceConnection(ConnectionEditPart connection) {
        this.fireRemovingSourceConnection(connection, this.getSourceConnections().indexOf(connection));
        if (connection.getSource() == this) {
            connection.deactivate();
            connection.setSource(null);
        }
        this.primRemoveSourceConnection(connection);
    }

    protected void removeTargetConnection(ConnectionEditPart connection) {
        this.fireRemovingTargetConnection(connection, this.getTargetConnections().indexOf(connection));
        if (connection.getTarget() == this) {
            connection.setTarget(null);
        }
        this.primRemoveTargetConnection(connection);
    }

    @Override
    protected void reorderChild(EditPart child, int index) {
        IFigure childFigure = ((GraphicalEditPart)child).getFigure();
        LayoutManager layout = this.getContentPane().getLayoutManager();
        Object constraint = null;
        if (layout != null) {
            constraint = layout.getConstraint(childFigure);
        }
        super.reorderChild(child, index);
        this.setLayoutConstraint(child, childFigure, constraint);
    }

    protected void reorderSourceConnection(ConnectionEditPart connection, int index) {
        this.primRemoveSourceConnection(connection);
        this.primAddSourceConnection(connection, index);
    }

    protected void reorderTargetConnection(ConnectionEditPart connection, int index) {
        this.primRemoveTargetConnection(connection);
        this.primAddTargetConnection(connection, index);
    }

    protected void setFigure(IFigure figure) {
        this.figure = figure;
    }

    @Override
    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        childFigure.getParent().setConstraint(childFigure, constraint);
    }

    @Override
    protected void unregisterVisuals() {
        this.getViewer().getVisualPartMap().remove(this.getFigure());
    }

    protected abstract class AccessibleGraphicalEditPart
    extends AccessibleEditPart {
        protected AccessibleGraphicalEditPart() {
        }

        @Override
        public void getChildCount(AccessibleControlEvent e) {
            e.detail = AbstractGraphicalEditPart.this.getChildren().size();
        }

        @Override
        public void getChildren(AccessibleControlEvent e) {
            ArrayList<Integer> children = new ArrayList<Integer>(AbstractGraphicalEditPart.this.getChildren().size());
            for (EditPart editPart : AbstractGraphicalEditPart.this.getChildren()) {
                AccessibleEditPart access = (AccessibleEditPart)((Object)editPart.getAdapter(AccessibleEditPart.class));
                if (access == null) {
                    return;
                }
                children.add(access.getAccessibleID());
            }
            e.children = children.toArray();
        }

        @Override
        public void getLocation(AccessibleControlEvent e) {
            Rectangle bounds = AbstractGraphicalEditPart.this.getFigure().getBounds().getCopy();
            AbstractGraphicalEditPart.this.getFigure().translateToAbsolute((Translatable)bounds);
            org.eclipse.swt.graphics.Point p = new org.eclipse.swt.graphics.Point(0, 0);
            p = AbstractGraphicalEditPart.this.getViewer().getControl().toDisplay(p);
            e.x = bounds.x + p.x;
            e.y = bounds.y + p.y;
            e.width = bounds.width;
            e.height = bounds.height;
        }

        @Override
        public void getState(AccessibleControlEvent e) {
            e.detail = 0x300000;
            if (AbstractGraphicalEditPart.this.getSelected() != 0) {
                e.detail |= 2;
            }
            if (AbstractGraphicalEditPart.this.getViewer().getFocusEditPart() == AbstractGraphicalEditPart.this) {
                e.detail |= 4;
            }
        }

        @Override
        public void getRole(AccessibleControlEvent e) {
            e.detail = 41;
        }
    }

    protected class DefaultAccessibleAnchorProvider
    implements AccessibleAnchorProvider {
        protected DefaultAccessibleAnchorProvider() {
        }

        private List<Point> getDefaultLocations() {
            ArrayList<Point> list = new ArrayList<Point>();
            Rectangle r = AbstractGraphicalEditPart.this.getFigure().getBounds();
            Point p = r.getTopRight().translate(-1, r.height / 3);
            AbstractGraphicalEditPart.this.getFigure().translateToAbsolute((Translatable)p);
            list.add(p);
            return list;
        }

        @Override
        public List<Point> getSourceAnchorLocations() {
            return this.getDefaultLocations();
        }

        @Override
        public List<Point> getTargetAnchorLocations() {
            return this.getDefaultLocations();
        }
    }

    static class MergedAccessibleHandles
    implements AccessibleHandleProvider {
        List<Point> locations = new ArrayList<Point>();

        MergedAccessibleHandles(Iterable<EditPolicy> iterable) {
            for (EditPolicy policy : iterable) {
                IAdaptable adaptable;
                AccessibleHandleProvider adapter;
                if (!(policy instanceof IAdaptable) || (adapter = (AccessibleHandleProvider)(adaptable = (IAdaptable)policy).getAdapter(AccessibleHandleProvider.class)) == null) continue;
                this.locations.addAll(adapter.getAccessibleHandleLocations());
            }
        }

        @Override
        public List<Point> getAccessibleHandleLocations() {
            return this.locations;
        }
    }
}

