/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppVersionType;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.ArchiveFile;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.project.facet.J2EEUtils;
import org.eclipse.jst.jsf.core.internal.project.facet.JEEUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class JSFUtils {
    public static final String JSF_DEFAULT_SERVLET_NAME = "Faces Servlet";
    public static final String JSF_SERVLET_CLASS = "javax.faces.webapp.FacesServlet";
    public static final String JSF_CONFIG_CONTEXT_PARAM = "javax.faces.CONFIG_FILES";
    public static final String JSF_DEFAULT_SUFFIX_CONTEXT_PARAM = "javax.faces.DEFAULT_SUFFIX";
    public static final String JSF_DEFAULT_CONFIG_PATH = "/WEB-INF/faces-config.xml";
    public static final String JSF_DEFAULT_URL_MAPPING = "/faces/*";
    public static final String PP_JSF_IMPLEMENTATION_LIBRARIES = "jsf.implementation.libraries";
    public static final String PP_JSF_COMPONENT_LIBRARIES = "jsf.component.libraries";
    public static final String PP_JSF_IMPLEMENTATION_TYPE = "jsf.implementation.type";
    private static final String DEFAULT_DEFAULT_MAPPING_SUFFIX = "jsp";
    private static final String SYS_PROP_SERVLET_MAPPING = "org.eclipse.jst.jsf.servletMapping";
    private final JSFVersion _version;
    private final IModelProvider _modelProvider;

    protected JSFUtils(JSFVersion version, IModelProvider modelProvider) {
        this._version = version;
        this._modelProvider = modelProvider;
    }

    public final JSFVersion getVersion() {
        return this._version;
    }

    protected final String getDisplayName(IDataModel config) {
        String displayName = config.getStringProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME");
        if (displayName == null || displayName.trim().length() == 0) {
            displayName = JSF_DEFAULT_SERVLET_NAME;
        }
        return displayName.trim();
    }

    protected final String getServletClassname(IDataModel config) {
        String className = config.getStringProperty("IJSFFacetInstallDataModelProperties.SERVLET_CLASSNAME");
        if (className == null || className.trim().equals("")) {
            className = JSF_SERVLET_CLASS;
        }
        return className.trim();
    }

    public final IModelProvider getModelProvider() {
        Object webAppObj = this._modelProvider.getModelObject();
        if (webAppObj == null) {
            return null;
        }
        return this._modelProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void createConfigFile(IPath configPath) {
        FileOutputStream os = null;
        try {
            try {
                IPath dirPath = configPath.removeLastSegments(1);
                dirPath.toFile().mkdirs();
                File file = configPath.toFile();
                file.createNewFile();
                os = new FileOutputStream(file);
                this.printConfigFile(os);
                return;
            }
            catch (FileNotFoundException e) {
                JSFCorePlugin.log(4, Messages.JSFUtils_ErrorCreatingConfigFile, e);
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException e2) {
                    JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e2);
                }
                return;
            }
            catch (IOException e) {
                JSFCorePlugin.log(4, Messages.JSFUtils_ErrorCreatingConfigFile, e);
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException e3) {
                    JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e3);
                }
                return;
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    JSFCorePlugin.log(4, Messages.JSFUtils_ErrorClosingConfigFile, e);
                }
            }
        }
    }

    protected final void printConfigFile(OutputStream out) {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(out);
            this.doVersionSpecificConfigFile(pw);
        }
    }

    public abstract void doVersionSpecificConfigFile(PrintWriter var1);

    public boolean isJavaEE(Object webAppObj) {
        if (webAppObj instanceof WebApp) {
            WebApp webApp = (WebApp)webAppObj;
            return WebAppVersionType.VALUES.contains(webApp.getVersion());
        }
        return false;
    }

    protected final List<String> getServletMappings(IDataModel config) {
        ArrayList<String> mappings = new ArrayList<String>();
        String[] patterns = (String[])config.getProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS");
        if (patterns != null) {
            String[] stringArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                mappings.add(pattern);
                ++n2;
            }
        }
        return mappings;
    }

    public abstract void updateWebApp(Object var1, IDataModel var2);

    public abstract void rollbackWebApp(Object var1);

    protected boolean isValidKnownExtension(String fileExtension) {
        ArrayList<String> validKnownExtensions = new ArrayList<String>();
        String[] stringArray = new String[]{"org.eclipse.jst.jsp.core.jspsource", "org.eclipse.jst.jsp.core.jspfragmentsource", "jsf.facelet"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] contentTypeExts;
            String contentTypeId = stringArray[n2];
            IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
            if (contentType != null && (contentTypeExts = contentType.getFileSpecs(8)) != null) {
                validKnownExtensions.addAll(Arrays.asList(contentTypeExts));
            }
            ++n2;
        }
        if (fileExtension != null) {
            return validKnownExtensions.contains(fileExtension);
        }
        return false;
    }

    protected boolean isJSFPage(IResource resource) {
        boolean isJSFPage = true;
        if (resource == null) {
            isJSFPage = false;
        }
        return isJSFPage;
    }

    protected String getDefaultSuffix(Object webApp) {
        String contextParam = null;
        if (webApp != null) {
            contextParam = this.isJavaEE(webApp) ? JEEUtils.getContextParam((WebApp)webApp, JSF_DEFAULT_SUFFIX_CONTEXT_PARAM) : J2EEUtils.getContextParam((org.eclipse.jst.j2ee.webapplication.WebApp)webApp, JSF_DEFAULT_SUFFIX_CONTEXT_PARAM);
        }
        if (contextParam == null) {
            return this.getDefaultDefaultSuffix();
        }
        return this.normalizeSuffix(contextParam);
    }

    protected String getDefaultDefaultSuffix() {
        return DEFAULT_DEFAULT_MAPPING_SUFFIX;
    }

    protected final String calculateSuffix(String name, String value) {
        if (name != null && JSF_DEFAULT_SUFFIX_CONTEXT_PARAM.equals(name.trim())) {
            return this.normalizeSuffix(value != null ? value.trim() : null);
        }
        return null;
    }

    protected final String normalizeSuffix(String defSuffix) {
        if (defSuffix != null && defSuffix.startsWith(".")) {
            defSuffix = defSuffix.substring(1);
        }
        return defSuffix;
    }

    protected Object findJSFServlet(Object webApp) {
        if (this.isJavaEE(webApp)) {
            return JEEUtils.findServlet((WebApp)webApp, JSF_SERVLET_CLASS);
        }
        return J2EEUtils.findServlet((org.eclipse.jst.j2ee.webapplication.WebApp)webApp, JSF_SERVLET_CLASS);
    }

    protected Object createOrUpdateServletRef(Object webApp, IDataModel config, Object servlet) {
        String displayName = this.getDisplayName(config);
        String className = this.getServletClassname(config);
        if (this.isJavaEE(webApp)) {
            return JEEUtils.createOrUpdateServletRef((WebApp)webApp, displayName, className, (org.eclipse.jst.javaee.web.Servlet)servlet);
        }
        return J2EEUtils.createOrUpdateServletRef((org.eclipse.jst.j2ee.webapplication.WebApp)webApp, displayName, className, (Servlet)servlet);
    }

    protected void setUpURLMappings(Object webApp, List<String> urlMappingList, Object servlet) {
        if (this.isJavaEE(webApp)) {
            JEEUtils.setUpURLMappings((WebApp)webApp, urlMappingList, (org.eclipse.jst.javaee.web.Servlet)servlet);
        } else {
            J2EEUtils.setUpURLMappings((org.eclipse.jst.j2ee.webapplication.WebApp)webApp, urlMappingList, (Servlet)servlet);
        }
    }

    protected void removeURLMappings(Object webApp, Object servlet) {
        if (this.isJavaEE(webApp)) {
            JEEUtils.removeURLMappings((WebApp)webApp, (org.eclipse.jst.javaee.web.Servlet)servlet);
        } else {
            J2EEUtils.removeURLMappings((org.eclipse.jst.j2ee.webapplication.WebApp)webApp, (Servlet)servlet);
        }
    }

    protected void removeJSFServlet(Object webApp, Object servlet) {
        if (this.isJavaEE(webApp)) {
            JEEUtils.removeServlet((WebApp)webApp, (org.eclipse.jst.javaee.web.Servlet)servlet);
        } else {
            J2EEUtils.removeServlet((org.eclipse.jst.j2ee.webapplication.WebApp)webApp, (Servlet)servlet);
        }
    }

    protected void removeJSFContextParams(Object webApp) {
        if (this.isJavaEE(webApp)) {
            JEEUtils.removeContextParam((WebApp)webApp, JSF_CONFIG_CONTEXT_PARAM);
        } else {
            J2EEUtils.removeContextParam((org.eclipse.jst.j2ee.webapplication.WebApp)webApp, JSF_CONFIG_CONTEXT_PARAM);
        }
    }

    protected void setupContextParams(Object webApp, IDataModel config) {
        String paramValue = config.getStringProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH");
        if (paramValue != null && !paramValue.equals(JSF_DEFAULT_CONFIG_PATH)) {
            if (this.isJavaEE(webApp)) {
                JEEUtils.setupContextParam((WebApp)webApp, JSF_CONFIG_CONTEXT_PARAM, paramValue);
            } else {
                J2EEUtils.setupContextParam((org.eclipse.jst.j2ee.webapplication.WebApp)webApp, JSF_CONFIG_CONTEXT_PARAM, paramValue);
            }
        }
    }

    protected String getFileExtensionFromMap(Object webApp, Object map) {
        if (this.isJavaEE(webApp)) {
            return JEEUtils.getFileExtensionFromMap((ServletMapping)map);
        }
        return J2EEUtils.getFileExtensionFromMap((org.eclipse.jst.j2ee.webapplication.ServletMapping)map);
    }

    protected String getPrefixMapping(Object webApp, Object map) {
        if (this.isJavaEE(webApp)) {
            return JEEUtils.getPrefixMapping((ServletMapping)map);
        }
        return J2EEUtils.getPrefixMapping((org.eclipse.jst.j2ee.webapplication.ServletMapping)map);
    }

    public IPath getFileUrlPath(Object webAppObj, IResource resource, IPath existingURL) {
        boolean canUseExtensionMapping;
        if (!this.isJSFPage(resource)) {
            return null;
        }
        Object servlet = this.findJSFServlet(webAppObj);
        ArrayList implicitServletMappings = new ArrayList();
        if (servlet == null) {
            servlet = this.createImplicitServletAndMapping(webAppObj, implicitServletMappings);
        }
        String defaultSuffix = this.getDefaultSuffix(webAppObj);
        String fileExtension = resource.getFileExtension();
        boolean bl = canUseExtensionMapping = fileExtension != null && fileExtension.equalsIgnoreCase(defaultSuffix);
        if (!canUseExtensionMapping && !this.isValidKnownExtension(resource.getFileExtension())) {
            return null;
        }
        if (this.isJavaEE(webAppObj)) {
            WebApp webApp = (WebApp)webAppObj;
            String servletName = ((org.eclipse.jst.javaee.web.Servlet)servlet).getServletName();
            String foundFileExtension = null;
            List mappings = webApp.getServletMappings().size() > 0 ? webApp.getServletMappings() : implicitServletMappings;
            for (ServletMapping map : mappings) {
                if (map == null || map.getServletName() == null || !map.getServletName().trim().equals(servletName.trim())) continue;
                foundFileExtension = this.getFileExtensionFromMap(webAppObj, map);
                if (foundFileExtension != null && canUseExtensionMapping) {
                    return existingURL.removeFileExtension().addFileExtension(foundFileExtension);
                }
                String foundPrefixMapping = this.getPrefixMapping(webAppObj, map);
                if (foundPrefixMapping == null) continue;
                return new Path(foundPrefixMapping).append(existingURL);
            }
            if (!canUseExtensionMapping && foundFileExtension != null) {
                return existingURL.removeFileExtension().addFileExtension(foundFileExtension);
            }
        } else {
            List mappings = ((Servlet)servlet).getMappings().size() > 0 ? ((Servlet)servlet).getMappings() : implicitServletMappings;
            Iterator itMappings = mappings.iterator();
            org.eclipse.jst.j2ee.webapplication.ServletMapping map = null;
            String foundFileExtension = null;
            String foundPrefixMapping = null;
            while (itMappings.hasNext()) {
                map = (org.eclipse.jst.j2ee.webapplication.ServletMapping)itMappings.next();
                foundFileExtension = this.getFileExtensionFromMap(webAppObj, map);
                if (foundFileExtension != null && canUseExtensionMapping) {
                    return existingURL.removeFileExtension().addFileExtension(foundFileExtension);
                }
                if (foundPrefixMapping != null) continue;
                foundPrefixMapping = this.getPrefixMapping(webAppObj, map);
            }
            if (foundPrefixMapping != null) {
                return new Path(foundPrefixMapping).append(existingURL);
            }
            if (!canUseExtensionMapping && foundFileExtension != null) {
                return existingURL.removeFileExtension().addFileExtension(foundFileExtension);
            }
        }
        return null;
    }

    private Object createImplicitServletAndMapping(Object webApp, List mappings) {
        org.eclipse.jst.javaee.web.Servlet servlet;
        String sysPropServletMapping = System.getProperty(SYS_PROP_SERVLET_MAPPING);
        if (sysPropServletMapping == null) {
            sysPropServletMapping = JSF_DEFAULT_URL_MAPPING;
        }
        if (this.isJavaEE(webApp)) {
            servlet = WebFactory.eINSTANCE.createServlet();
            servlet.setServletName(JSF_DEFAULT_SERVLET_NAME);
            ServletMapping mapping = WebFactory.eINSTANCE.createServletMapping();
            mapping.setServletName(JSF_DEFAULT_SERVLET_NAME);
            UrlPatternType pattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
            pattern.setValue(sysPropServletMapping);
            mapping.getUrlPatterns().add(pattern);
            mappings.add(mapping);
        } else {
            servlet = WebapplicationFactory.eINSTANCE.createServlet();
            ((Servlet)servlet).setServletName(JSF_DEFAULT_SERVLET_NAME);
            org.eclipse.jst.j2ee.webapplication.ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
            mapping.setUrlPattern(sysPropServletMapping);
            mappings.add(mapping);
        }
        return servlet;
    }

    public static class JSFLibraryHandler {
        public final IPath[] getJARPathforJSFLib(JSFLibrary jsfLib, boolean logMissingJar) {
            EList archiveFiles = jsfLib.getArchiveFiles();
            int numJars = archiveFiles.size();
            IPath[] elements = new IPath[numJars];
            ArchiveFile ar = null;
            int i = 0;
            while (i < numJars) {
                ar = (ArchiveFile)archiveFiles.get(i);
                if (!ar.exists() && logMissingJar) {
                    this.logErroronMissingJAR(jsfLib, ar);
                }
                elements[i] = new Path(((ArchiveFile)archiveFiles.get(i)).getResolvedSourceLocation()).makeAbsolute();
                ++i;
            }
            return elements;
        }

        private int numberofValidJar(EList archiveFiles) {
            int total = 0;
            Iterator it = archiveFiles.iterator();
            ArchiveFile ar = null;
            while (it.hasNext()) {
                ar = (ArchiveFile)it.next();
                if (!ar.exists()) continue;
                ++total;
            }
            return total;
        }

        private void logErroronMissingJAR(JSFLibrary jsfLib, ArchiveFile ar) {
            String msg = NLS.bind((String)Messages.JSFUtils_MissingJAR, (Object)ar.getName(), (Object)jsfLib.getLabel());
            JSFCorePlugin.log(4, msg);
        }

        public final IPath[] getJARPathforJSFLibwFilterMissingJars(JSFLibrary jsfLib, boolean logMissingJar) {
            EList archiveFiles = jsfLib.getArchiveFiles();
            int numJars = this.numberofValidJar(archiveFiles);
            IPath[] elements = new IPath[numJars];
            ArchiveFile ar = null;
            int idxValidJar = 0;
            int i = 0;
            while (i < archiveFiles.size()) {
                ar = (ArchiveFile)archiveFiles.get(i);
                if (!ar.exists()) {
                    if (logMissingJar) {
                        this.logErroronMissingJAR(jsfLib, ar);
                    }
                } else {
                    elements[idxValidJar] = new Path(((ArchiveFile)archiveFiles.get(i)).getResolvedSourceLocation()).makeAbsolute();
                    ++idxValidJar;
                }
                ++i;
            }
            return elements;
        }
    }
}

