/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.internal.JSPUtil;
import org.eclipse.jst.jsf.common.internal.resource.EventResult;
import org.eclipse.jst.jsf.common.internal.resource.ILifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ImmutableLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.view.AbstractDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.AbstractViewDefnAdapterFactory;
import org.eclipse.jst.jsf.designtime.internal.view.DTUIViewRoot;
import org.eclipse.jst.jsf.designtime.internal.view.DefaultDTUIViewRoot;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.IViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.IViewDefnAdapterFactory;
import org.eclipse.jst.jsf.designtime.internal.view.JSPViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.XMLComponentTreeConstructionStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.w3c.dom.Node;

public class DefaultDTViewHandler
extends AbstractDTViewHandler {
    private final MyLifecycleManager _lifecycleManager = new MyLifecycleManager();

    @Override
    public String calculateLocale(DTFacesContext context) throws IDTViewHandler.ViewHandlerException {
        return null;
    }

    @Override
    public IResource getActionDefinition(DTFacesContext context, String viewId) throws IDTViewHandler.ViewHandlerException {
        return context.adaptContextObject();
    }

    @Override
    public IPath getActionURL(DTFacesContext context, IResource resource, IPath requestPath) throws IDTViewHandler.ViewHandlerException {
        return null;
    }

    @Override
    public IPath getRelativeActionPath(DTFacesContext context, String relativeToViewId, String uri) throws IDTViewHandler.ViewHandlerException {
        return null;
    }

    @Override
    public IViewDefnAdapterFactory getViewMetadataAdapterFactory(DTFacesContext context) throws IDTViewHandler.ViewHandlerException {
        return this.internalGetViewMetadataAdapterFactory(context);
    }

    protected IViewDefnAdapterFactory getDefaultViewMetadataAdapterFactory(DTFacesContext context) {
        return this.internalGetViewMetadataAdapterFactory(context);
    }

    private IViewDefnAdapterFactory internalGetViewMetadataAdapterFactory(DTFacesContext context) {
        IResource res = context.adaptContextObject();
        if (res instanceof IFile) {
            return new DefaultViewDefnAdapterFactory(this);
        }
        return null;
    }

    @Override
    protected DTUIViewRoot.VersionStamp createVersionStamp(DTFacesContext facesContext, String viewId) {
        return new AbstractDTViewHandler.TimeBasedVersionStamp();
    }

    @Override
    protected DTUIViewRoot internalCreateView(DTFacesContext facesContext, String viewId) {
        try {
            IViewDefnAdapterFactory factory = this.getViewMetadataAdapterFactory(facesContext);
            if (factory != null) {
                IViewDefnAdapter<?, ?> adapter = factory.createAdapter(facesContext, viewId);
                if (adapter instanceof XMLViewDefnAdapter) {
                    IResource res = facesContext.adaptContextObject();
                    DTUIViewRoot root = this.newView(facesContext, viewId);
                    XMLComponentTreeConstructionStrategy constructionStrategy = this.createTreeConstructionStrategy((XMLViewDefnAdapter)adapter, res.getProject());
                    constructionStrategy.createComponentTree(facesContext, root);
                    return root;
                }
                JSFCorePlugin.log(2, String.format("Could not get view adapter to construct design time view root for %s", viewId));
            } else {
                JSFCorePlugin.log(2, String.format("Could not get view adapter factory toconstruct design time view root for %s", viewId));
            }
        }
        catch (IDTViewHandler.ViewHandlerException e) {
            JSFCorePlugin.log(e, "While acquiring view defn adapter factory");
        }
        return new AbstractDTViewHandler.NullViewRoot();
    }

    protected DTUIViewRoot newView(DTFacesContext facesContext, String viewId) {
        return new DefaultDTUIViewRoot(facesContext);
    }

    @Override
    protected void registerView(DTUIViewRoot viewRoot, DTFacesContext facesContext, String viewId) {
        IResource res = facesContext.adaptContextObject();
        this._lifecycleManager.addViewInfo(viewId, res);
    }

    protected XMLComponentTreeConstructionStrategy createTreeConstructionStrategy(XMLViewDefnAdapter adapter, IProject project) {
        return new XMLComponentTreeConstructionStrategy(adapter, project);
    }

    @Override
    public boolean supportsViewDefinition(IFile file) {
        return JSPUtil.isJSPContentType((IFile)file);
    }

    @Override
    protected DTUIViewRoot.StalenessAdvisor createStalenessAdvisor(DTUIViewRoot viewRoot, DTFacesContext facesContext, String viewId) {
        IResource res = facesContext.adaptContextObject();
        if (!(viewRoot instanceof AbstractDTViewHandler.NullViewRoot) && res != null) {
            return new ResourceModStampStalenessAdvisor(viewRoot, res, viewId);
        }
        return new AbstractDTViewHandler.NullStalenessAdvisor();
    }

    @Override
    public final void setLifecycleListener(ImmutableLifecycleListener listener) {
        this._lifecycleManager.update(listener);
    }

    @Override
    protected final void doDispose() {
        this._lifecycleManager.dispose();
    }

    static class DefaultViewDefnAdapterFactory
    extends AbstractViewDefnAdapterFactory {
        private final DefaultDTViewHandler _myViewHandler;

        DefaultViewDefnAdapterFactory(DefaultDTViewHandler viewHandler) {
            this._myViewHandler = viewHandler;
        }

        @Override
        public IViewDefnAdapter<Node, IDocument> createAdapter(DTFacesContext context, String viewId) {
            try {
                IResource res = this._myViewHandler.getActionDefinition(context, viewId);
                if (res instanceof IFile) {
                    IFile srcFile = (IFile)res;
                    ITagRegistry registry = this.findTagRegistry(srcFile);
                    if (JSPUtil.isJSPContentType((IFile)srcFile) && registry != null) {
                        return new JSPViewDefnAdapter(registry);
                    }
                }
            }
            catch (IDTViewHandler.ViewHandlerException vhe) {
                JSFCorePlugin.log(vhe, "While acquiring view adapter");
            }
            return null;
        }
    }

    private class MyLifecycleManager
    implements IResourceLifecycleListener {
        private ImmutableLifecycleListener _listener;
        private final Map<IResource, ViewInfo> _stalenessListeners = new HashMap<IResource, ViewInfo>();
        private final IResourceChangeListener _buildListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 8 && event.getBuildKind() == 15) {
                    if (event.getSource() instanceof IProject) {
                        MyLifecycleManager.this.cleanProject((IProject)event.getSource());
                    } else if (event.getSource() instanceof IWorkspace) {
                        MyLifecycleManager.this.cleanAll();
                    }
                }
            }
        };

        public MyLifecycleManager() {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this._buildListener, 8);
        }

        public void addListener(IResource res, DTUIViewRoot.StalenessListener listener) {
            ViewInfo viewInfo = this.getViewInfo(res);
            viewInfo.getListeners().addIfAbsent(listener);
        }

        public void removeListener(IResource res, DTUIViewRoot.StalenessListener listener) {
            ViewInfo viewInfo = this.getViewInfo(res);
            viewInfo.getListeners().remove(listener);
        }

        public EventResult acceptEvent(ResourceLifecycleEvent event) {
            switch (event.getEventType()) {
                case RESOURCE_CHANGED: {
                    return this.handleContentChangeEvent(event);
                }
                case RESOURCE_INACCESSIBLE: {
                    return this.handleInaccessibleChangeEvent(event);
                }
            }
            return EventResult.getDefaultEventResult();
        }

        private EventResult handleContentChangeEvent(ResourceLifecycleEvent event) {
            if (event.getReasonType() != ResourceLifecycleEvent.ReasonType.RESOURCE_CHANGED_CONTENTS) {
                return EventResult.getDefaultEventResult();
            }
            IResource res = event.getAffectedResource();
            List<DTUIViewRoot.StalenessListener> stalenessListeners = this.getListeners(res);
            if (stalenessListeners != null) {
                for (DTUIViewRoot.StalenessListener listener : stalenessListeners) {
                    listener.stalenessChanged(new DTUIViewRoot.StalenessEvent(DTUIViewRoot.StalenessEvent.ChangeType.VIEW_DEFN_CHANGED));
                }
            }
            return EventResult.getDefaultEventResult();
        }

        private EventResult handleInaccessibleChangeEvent(ResourceLifecycleEvent event) {
            IResource res = event.getAffectedResource();
            ResourceLifecycleEvent.ReasonType reasonType = event.getReasonType();
            DTUIViewRoot.StalenessEvent.ChangeType changeType = null;
            if (reasonType == ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_CLOSED) {
                changeType = DTUIViewRoot.StalenessEvent.ChangeType.VIEW_DEFN_PROJECT_CLOSED;
            } else if (reasonType == ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED) {
                changeType = DTUIViewRoot.StalenessEvent.ChangeType.VIEW_DEFN_DELETED;
            } else {
                return EventResult.getDefaultEventResult();
            }
            List<DTUIViewRoot.StalenessListener> listeners = this.getListeners(res);
            if (listeners != null) {
                for (DTUIViewRoot.StalenessListener listener : listeners) {
                    listener.stalenessChanged(new DTUIViewRoot.StalenessEvent(changeType));
                }
            }
            return EventResult.getDefaultEventResult();
        }

        private void cleanAll() {
            DTUIViewRoot.StalenessEvent event = new DTUIViewRoot.StalenessEvent(DTUIViewRoot.StalenessEvent.ChangeType.PROJECT_CLEANED);
            for (Map.Entry<IResource, ViewInfo> entry : this._stalenessListeners.entrySet()) {
                ViewInfo info = entry.getValue();
                for (DTUIViewRoot.StalenessListener listener : info.getListeners()) {
                    listener.stalenessChanged(event);
                }
            }
        }

        private void cleanProject(IProject project) {
            DTUIViewRoot.StalenessEvent event = new DTUIViewRoot.StalenessEvent(DTUIViewRoot.StalenessEvent.ChangeType.PROJECT_CLEANED);
            for (Map.Entry<IResource, ViewInfo> entry : this._stalenessListeners.entrySet()) {
                IResource res = entry.getKey();
                if (!res.getProject().equals((Object)project)) continue;
                ViewInfo info = entry.getValue();
                for (DTUIViewRoot.StalenessListener listener : info.getListeners()) {
                    listener.stalenessChanged(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<DTUIViewRoot.StalenessListener> getListeners(IResource res) {
            CopyOnWriteArrayList<DTUIViewRoot.StalenessListener> stalenessListeners = null;
            MyLifecycleManager myLifecycleManager = this;
            synchronized (myLifecycleManager) {
                ViewInfo viewInfo = this._stalenessListeners.get(res);
                if (viewInfo != null) {
                    stalenessListeners = viewInfo.getListeners();
                }
            }
            return stalenessListeners;
        }

        public synchronized void addViewInfo(String viewId, IResource res) {
            ViewInfo viewInfo = this._stalenessListeners.get(res);
            if (viewInfo == null) {
                viewInfo = new ViewInfo(viewId);
                this._stalenessListeners.put(res, viewInfo);
            }
        }

        public synchronized ViewInfo getViewInfo(IResource res) {
            return this._stalenessListeners.get(res);
        }

        public synchronized void dispose() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this._buildListener);
            this.update(null);
        }

        public synchronized void update(ImmutableLifecycleListener listener) {
            if (listener == this._listener) {
                return;
            }
            ImmutableLifecycleListener oldListener = this._listener;
            if (oldListener != null) {
                oldListener.removeListener((ILifecycleListener)this);
            }
            this._listener = listener;
            if (this._listener != null) {
                this._listener.addListener((ILifecycleListener)this);
            }
        }
    }

    protected final class ResourceModStampStalenessAdvisor
    extends DTUIViewRoot.StalenessAdvisor
    implements Serializable {
        private static final long serialVersionUID = -4982206388722638735L;
        private final long _modificationStamp;
        private final transient IResource _res;
        private final transient AtomicBoolean _forcedStale;
        private final transient DTUIViewRoot.StalenessListener _myListener;

        public ResourceModStampStalenessAdvisor(DTUIViewRoot viewRoot, IResource file, String viewId) {
            this._res = file;
            this._modificationStamp = file.getModificationStamp();
            this._forcedStale = new AtomicBoolean(false);
            this._myListener = new DTUIViewRoot.StalenessListener(){

                @Override
                protected void stalenessChanged(DTUIViewRoot.StalenessEvent event) {
                    if (event.getChangeType() == DTUIViewRoot.StalenessEvent.ChangeType.PROJECT_CLEANED && ResourceModStampStalenessAdvisor.this._forcedStale.compareAndSet(false, true)) {
                        ((ResourceModStampStalenessAdvisor)ResourceModStampStalenessAdvisor.this).DefaultDTViewHandler.this._lifecycleManager.removeListener(ResourceModStampStalenessAdvisor.this._res, ResourceModStampStalenessAdvisor.this._myListener);
                    }
                }
            };
            DefaultDTViewHandler.this._lifecycleManager.addViewInfo(viewId, this._res);
            DefaultDTViewHandler.this._lifecycleManager.addListener(this._res, this._myListener);
        }

        @Override
        public boolean isStale() {
            if (!this._forcedStale.get()) {
                long curStamp = this._res.getModificationStamp();
                return curStamp != this._modificationStamp;
            }
            return true;
        }

        @Override
        public void addListener(DTUIViewRoot.StalenessListener listener) {
            DefaultDTViewHandler.this._lifecycleManager.addListener(this._res, listener);
        }

        @Override
        public void removeListener(DTUIViewRoot.StalenessListener listener) {
            DefaultDTViewHandler.this._lifecycleManager.removeListener(this._res, listener);
        }

        @Override
        public boolean isAccessible() {
            return this._res.isAccessible();
        }
    }

    private static class ViewInfo {
        private final CopyOnWriteArrayList<DTUIViewRoot.StalenessListener> _listeners = new CopyOnWriteArrayList();

        private ViewInfo(String viewId) {
        }

        protected final CopyOnWriteArrayList<DTUIViewRoot.StalenessListener> getListeners() {
            return this._listeners;
        }
    }
}

