/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.modisco.facet.efacet.core.IFacetManager;
import org.eclipse.modisco.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.modisco.facet.efacet.ui.internal.Messages;
import org.eclipse.modisco.facet.efacet.ui.internal.exported.dialog.IUriDialogFactory;
import org.eclipse.modisco.facet.efacet.ui.internal.exported.widget.IUriWidget;
import org.eclipse.modisco.facet.efacet.ui.internal.handlers.Utils;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IDialog;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IOkDialogFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;

public class SetStructuralFeatureInstanceResourceHandler
extends AbstractHandler {
    public boolean isEnabled() {
        return Utils.getFacetManager() != null;
    }

    public boolean isHandled() {
        return Utils.getFacetManager() != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDialog<IUriWidget> result = null;
        final IFacetManager facetManager = Utils.getFacetManager(event);
        if (facetManager != null) {
            IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
            IWorkbenchPartSite site = activePart.getSite();
            Shell shell = site.getShell();
            URI uri = SetStructuralFeatureInstanceResourceHandler.getSResourceUri(facetManager);
            IDialogCallback<URI> callback = new IDialogCallback<URI>(){

                public void committed(URI resultUri) {
                    SetStructuralFeatureInstanceResourceHandler.changeSerializationMgrURI(facetManager, resultUri);
                }
            };
            result = IUriDialogFactory.DEFAULT.openUriDialog(uri, callback, shell, Display.getDefault());
        }
        return result;
    }

    private static URI getSResourceUri(IFacetManager facetManager) {
        Resource sResource = facetManager.getSerializationResource();
        URI uri = null;
        if (sResource != null) {
            uri = sResource.getURI();
        }
        return uri;
    }

    public static void changeSerializationMgrURI(IFacetManager facetManager, URI uri) {
        Resource sResource = null;
        ResourceSet resourceSet = facetManager.getResourceSet();
        try {
            sResource = resourceSet.getResource(uri, true);
        }
        catch (Exception e) {
            sResource = resourceSet.createResource(uri);
        }
        try {
            facetManager.setSerializationResource(sResource);
        }
        catch (FacetManagerException e) {
            IOkDialogFactory.DEFAULT.openErrorDialog(new Shell(), (Exception)((Object)e), Messages.SetStructuralFeatureInstanceResourceHandler_SerializationUriSettigFailed);
        }
    }
}

