/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.services;

import java.util.LinkedList;
import java.util.Map;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

public class RetokenizingTokenSource
implements TokenSource {
    protected final TokenSource tokenSource;
    protected final Map<Integer, String> tokenDefMap;
    protected final LinkedList<Token> queue = new LinkedList();
    private int tINT = -1;
    private int tDOT = -1;
    private int tID = -1;
    private int tPLUS = -1;
    private int tMINUS = -1;

    public RetokenizingTokenSource(TokenSource tokenSource, Map<Integer, String> tokenDefMap) {
        this.tokenSource = tokenSource;
        this.tokenDefMap = tokenDefMap;
        for (Map.Entry<Integer, String> entry : tokenDefMap.entrySet()) {
            Integer tokenNumber = entry.getKey();
            String tokenName = entry.getValue();
            if ("RULE_SIMPLE_ID".equals(tokenName)) {
                this.tID = tokenNumber;
                continue;
            }
            if ("'.'".equals(tokenName)) {
                this.tDOT = tokenNumber;
                continue;
            }
            if ("RULE_INT".equals(tokenName)) {
                this.tINT = tokenNumber;
                continue;
            }
            if ("'+'".equals(tokenName)) {
                this.tPLUS = tokenNumber;
                continue;
            }
            if (!"'-'".equals(tokenName)) continue;
            this.tMINUS = tokenNumber;
        }
    }

    public String getSourceName() {
        return this.tokenSource.getSourceName();
    }

    protected boolean isInteger(String text) {
        int iMax = text.length();
        if (iMax <= 0) {
            return true;
        }
        char c = text.charAt(0);
        if (c < '1' || '9' < c) {
            return false;
        }
        int i = 0;
        while (i < iMax) {
            c = text.charAt(i);
            if (c < '0' || '9' < c) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Token nextToken() {
        String text;
        Token nextToken;
        int nextType;
        Token firstToken = this.peek(0);
        int firstType = firstToken.getType();
        if (firstType != this.tINT) {
            return this.queue.remove();
        }
        Token lastToken = firstToken;
        int index = 0;
        if ((nextType = (nextToken = this.peek(++index)).getType()) == this.tDOT) {
            if ((nextType = (nextToken = this.peek(++index)).getType()) != this.tINT) {
                return this.queue.remove();
            }
            lastToken = nextToken;
            nextToken = this.peek(++index);
            nextType = nextToken.getType();
        }
        if (nextType == this.tID && ((text = nextToken.getText()).startsWith("E") || text.startsWith("e"))) {
            if (text.length() == 1) {
                if ((nextType = (nextToken = this.peek(++index)).getType()) == this.tPLUS || nextType == this.tMINUS) {
                    nextToken = this.peek(++index);
                    nextType = nextToken.getType();
                }
                if (nextType == this.tINT) {
                    lastToken = nextToken;
                }
            } else if (this.isInteger(text.substring(1))) {
                lastToken = nextToken;
            }
        }
        if (firstToken == lastToken) {
            return this.queue.remove();
        }
        StringBuilder s = new StringBuilder();
        while ((nextToken = this.queue.remove()) != lastToken) {
            s.append(nextToken.getText());
        }
        s.append(nextToken.getText());
        String text2 = s.toString();
        CommonToken commonToken = new CommonToken(firstToken);
        commonToken.setStopIndex(commonToken.getStartIndex() + text2.length() - 1);
        commonToken.setText(text2);
        return commonToken;
    }

    protected Token peek(int index) {
        while (this.queue.size() <= index) {
            Token nextToken = this.tokenSource.nextToken();
            if (nextToken == null) {
                return Token.EOF_TOKEN;
            }
            this.queue.add(nextToken);
        }
        Token thisToken = this.queue.get(index);
        if (index > 0) {
            int thisLine;
            Token prevToken = this.queue.get(index - 1);
            int prevLine = prevToken.getLine();
            if (prevLine != (thisLine = thisToken.getLine())) {
                return Token.EOF_TOKEN;
            }
            String prevText = prevToken.getText();
            int prevCharPositionInLine = prevToken.getCharPositionInLine();
            int thisCharPositionInLine = thisToken.getCharPositionInLine();
            if (prevCharPositionInLine + prevText.length() != thisCharPositionInLine) {
                return Token.EOF_TOKEN;
            }
        }
        return thisToken;
    }
}

