/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.types.impl;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypesPackage;
import org.eclipse.ocl.types.operations.TupleTypeOperations;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.UMLReflection;

public class TupleTypeImpl<O, P>
extends EObjectImpl
implements TupleType<O, P> {
    private String name;
    private EList<O> operations;
    private EList<P> properties;

    protected TupleTypeImpl() {
    }

    protected EClass eStaticClass() {
        return TypesPackage.Literals.TUPLE_TYPE;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            Environment env = Environment.Registry.INSTANCE.getEnvironmentFor(this);
            UMLReflection uml = env.getUMLReflection();
            StringBuffer myName = new StringBuffer();
            myName.append("Tuple").append('(');
            Iterator iter = this.oclProperties().iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                myName.append(uml.getName(next));
                Object type = TypeUtil.resolveType(env, uml.getOCLType(next));
                if (type != null) {
                    myName.append(" : ");
                    myName.append(uml.getName(type));
                }
                if (!iter.hasNext()) continue;
                myName.append(", ");
            }
            myName.append(')');
            this.name = myName.toString();
        }
        return this.name;
    }

    @Override
    public EList<O> oclOperations() {
        if (this.operations == null) {
            Environment env = Environment.Registry.INSTANCE.getEnvironmentFor(this);
            this.operations = new BasicEList(OCLStandardLibraryUtil.createAnyTypeOperations(env));
        }
        return this.operations;
    }

    @Override
    public boolean checkTupleTypeName(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return TupleTypeOperations.checkTupleTypeName(this, diagnostics, context);
    }

    @Override
    public boolean checkPartNamesUnique(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return TupleTypeOperations.checkPartNamesUnique(this, diagnostics, context);
    }

    @Override
    public boolean checkFeaturesOnlyProperties(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return TupleTypeOperations.checkFeaturesOnlyProperties(this, diagnostics, context);
    }

    @Override
    public EList<P> oclProperties() {
        if (this.properties == null) {
            this.properties = new BasicEList();
        }
        return this.properties;
    }
}

